//#define _CRT_SECURE_NO_DEPRECATE
#pragma warning(disable : 4996)

#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <commctrl.h>
#include <time.h>
#include <limits.h>
#include <shlobj.h>
#include <vector>
#include <string>
#include <fstream>

//boost libraries
#include <boost/foreach.hpp>

#define foreach BOOST_FOREACH

using namespace std;

#ifdef _AMD64_
#include "../BasicCompiler64/resource.h"
#include "../BasicCompiler64/CommandValue.h"
#include "../BasicCompiler64/FunctionValue.h"
#define OPCODE_H_PATH "../BasicCompiler64/opcode.h"
#else
#include "../BasicCompiler32/resource.h"
#include "../BasicCompiler32/CommandValue.h"
#include "../BasicCompiler32/FunctionValue.h"
#define OPCODE_H_PATH "../BasicCompiler32/opcode.h"
#endif

#include "../BasicCompiler_Common/BasicFixed.h"
#include "../BasicCompiler_Common/NonVolatile.h"
#include "../BasicCompiler_Common/psapi.h"
#include "../BasicCompiler_Common/BreakPoint.h"
#include "../BasicCompiler_Common/LexicalScoping.h"



//o[W
#define MAJOR_VER		5
#define MINOR_VER		00
#define REVISION_VER	00

#ifdef _AMD64_
#define VER_INFO		"(x64)  rev.243"
#else
#define VER_INFO		" rev.243"
#endif

#if defined(JPN)
//{
#include "common_msg_jpn.h"
#else
//p
#include "common_msg_eng.h"
#endif


#define PTR_SIZE		sizeof(LONG_PTR)

#define MAX_LEN			65535
#define VN_SIZE			512
#define DIGIT_SIZE		128
#define MAX_PARMS		64
#define MAX_ARRAYDIM	16
#define MAX_HASH		32761


#ifdef _AMD64_
#define PLATFORM	64
#else
#define PLATFORM	32
typedef long LONG_PTR;
typedef DWORD ULONG_PTR;
#endif


//`̒萔
#ifndef IMAGE_FILE_MACHINE_AMD64
	#define IMAGE_FILE_MACHINE_AMD64 0x8664
#endif

#ifdef _AMD64_
	#ifndef IMAGE_SIZEOF_NT_OPTIONAL64_HEADER
		#define IMAGE_SIZEOF_NT_OPTIONAL64_HEADER    240
	#endif
#else
	#ifndef IMAGE_SIZEOF_NT_OPTIONAL32_HEADER
		#define IMAGE_SIZEOF_NT_OPTIONAL32_HEADER    224
	#endif
#endif


extern HWND hOwnerEditor;
extern HANDLE hHeap;
extern char BasicSystemDir[MAX_PATH];
extern int cp;
extern bool isUnicode;
extern int typeOfPtrChar;
extern int typeOfPtrUChar;



//////////////////////////////////////////
// BasicCompilerAProjectEditorʂ̒萔
//////////////////////////////////////////

//TCYύXg̑
#define LEVER_THICK 5

#define WM_SHOWERROR			WM_USER+70	//G[\bZ[W

#define WM_SETCOMPILEVIEW		WM_USER+71	//RpCEBhE\ꂽƂ
#define WM_DESTROYCOMPILEVIEW	WM_USER+72	//RpCEBhEjꂽƂ

#define WM_SETDEBUGGERBASE		WM_USER+73	//fobKx[XEBhE\ꂽƂ
#define WM_DESTROYDEBUGGERBASE	WM_USER+74	//fobKx[XEBhEjꂽƂ

#define WM_SETDEBUGGERVIEW		WM_USER+75	//fobKEBhE\ꂽƂ
#define WM_DESTROYDEBUGGERVIEW	WM_USER+76	//fobKEBhE\ꂽƂ

///////////////////////////////////////////


#define WM_SHOWVARLIST			WM_USER+80
#define WM_VARLIST_CLOSE		WM_USER+81	//ϐXg̏IbZ[Wiĵ݁AȂj



///////////////////////////////////////////
// fobO R}h

#define WM_DEBUG_CONTINUE	WM_USER+200
#define WM_STEP_IN			WM_USER+201
#define WM_STEP_OVER		WM_USER+202
#define WM_STEP_CURSOR		WM_USER+203
#define WM_DEBUG_STOP		WM_USER+204
#define WM_DEBUG_PAUSE		WM_USER+205
#define WM_CLOSE_DEBUGGER	WM_USER+206

///////////////////////////////////////////




#define FILE_ALIGNMENT	0x1000
#define MEM_ALIGNMENT	0x1000
#define EXE_HEADER_SIZE	0x1000


// NXǗp̃NX
#include "Class.h"

// 񋓑̊Ǘp̃NX
#include "Enum.h"

// 萔Ǘp̃NX
#include "Const.h"

// ϐǗp̃NX
#include "Variable.h"

// p[^Ǘp̃NX
#include "Parameter.h"

// vV[WǗp̃NX
#include "Procedure.h"

// RpCKvƂf[^nEX
#include <Smoothie.h>



struct ERRORINFO{
	char *FileName;
	int line;
};
struct INCLUDEFILEINFO{
	char **ppFileNames;
	int FilesNum;
	int LineOfFile[MAX_LEN];
};

//ϐ̑Ώ
struct RELATIVE_VAR{
	DWORD dwKind;
	LONG_PTR offset;
	BOOL bOffsetOffset;
};

struct CONSTINFO{
	char *name;
	char *StrValue;

	double DblValue;
	_int64 i64Value;
	int type;
	LONG_PTR lpIndex;

	int ParmNum;
	char **ppParm;

	CONSTINFO *pNextData;
};


#define CODETYPE_SYSTEMPROC		0x0001
#define CODETYPE_DEBUGPROC		0x0002
struct LINEINFO{
	int TopCp;
	int TopObp;
	DWORD dwCodeType;
};
struct RESOURCEDATAINFO{
	DWORD dwId;
	char FileName[MAX_PATH];
};


//////////////////////////////////////////
// \[X wb_iACRAJ[\pj
typedef struct{
	WORD idReserved;
	WORD idType;
	WORD idCount;
}ICONDIR,CURSORDIR;


/////////////////////////////
// .curt@C̃wb_
struct CURSORDIRENTRY{
	BYTE bWidth;
	BYTE bHeight;
	BYTE bColorCount;
	BYTE bReserved;
	WORD wXHotspot;
	WORD wYHotspot;
	DWORD dwBytesInRes;
	DWORD dwImageOffset;
};
struct CURSORDIRENTRY_RES{
	WORD wWidth;
	WORD wHeight;
	WORD wXHotspot;
	WORD wYHotspot;
	DWORD dwBytesInRes;
	WORD wCursorNum;
};


////////////////////////////
//.icot@C̃wb_
struct ICONDIRENTRY{
	BYTE bWidth;
	BYTE bHeight;
	BYTE bColorCount;
	BYTE bReserved;
	WORD wPlanes;
	WORD wBitCount;
	DWORD dwBytesInRes;
	DWORD dwImageOffset;
};
struct ICONDIRENTRY_RES{
	BYTE bWidth;
	BYTE bHeight;
	BYTE bColorCount;
	BYTE bReserved;
	WORD wPlanes;
	WORD wBitCount;
	DWORD dwBytesInRes;
	WORD wIconNum;
};



#include "../BasicCompiler_Common/PESchedule.h"
#include "../BasicCompiler_Common/DebugSection.h"
#include "../BasicCompiler_Common/VariableOpe.h"
#include "../BasicCompiler_Common/Exception.h"



bool StaticCalculation(bool enableerror, const char *Command,int BaseType,_int64 *pi64data,Type &resultType,BOOL bDebuggingWatchList=0, bool *pIsMemoryAccessError=NULL);


//BasicCompiler.cpp
void HeapDefaultFree(LPVOID lpMem);
void ts(int i);
void ts(int i,int i2);
void ts(char *msg);
void ts(char *msg,char *title);
void epi_check();
void GetRelationalPath(char *path,char *dir);
void GetFullPath(char *path,char *dir);
void ShowErrorLine(int LineNum,char *FileName);
BOOL GetFilePathDialog(HWND hwnd,char *filename,LPSTR Filter,LPSTR Title,BOOL bOpen);
void MakeMessageText(char *buffer,char *msg,int flag);

//hash.cpp
int hash_default(const char *name);
CONSTINFO *GetConstHash(const char *name);
DllProc *GetDeclareHash(char *name);
void GetOverloadSubHash( const char *lpszName, std::vector<UserProc *> &subs );
UserProc *GetSubHash(const char *name,BOOL bError=0);
UserProc *GetMethodHash(const char *ObjectName,const char *MethodName,const char *Parameter,BOOL bError=0);
UserProc *GetClassMethod( const char *className, const char *methodName );

//Object.cpp
void CallConstructor( const char *ObjectName,const int *SubScripts, const Type &type,const char *Parameter);
bool Operator_New( const char *expression, const Type &baseType, Type &resultType );

//Overload.sbp
UserProc *OverloadSolutionWithStrParam(
	const char *name,
	std::vector<UserProc *> &subs,
	const char *Parameter,
	const char *ObjectName);
UserProc *OverloadSolution(
	const char *name,
	std::vector<UserProc *> &subs,
	const Parameters &params,
	const Type &returnType );

//Debug.cpp
void Debugger_StepIn(void);
void Debugger_StepOver(void);
void Debugger_StepCursor(void);
void Debugger_Stop(void);
void Debugger_Pause(void);
ULONG_PTR rva_to_real(DWORD p);
GlobalProc *GetSubFromObp(ULONG_PTR pos);
void ReadOpBuffer();
void DebugProgram(void);

//VarList.cpp
void InitVarList(DWORD dwThreadId);
BOOL CALLBACK DlgDebugger(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam);
BOOL CALLBACK DlgVarList(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam);

//WatchList.cpp
ULONG_PTR Debugging_GetVarPtr(RELATIVE_VAR *pRelativeVar);
ULONG_PTR Debugging_GetThisPtrOffset(LONG_PTR obp_Rip);
int Debugging_GetVarOffset( char *variable,RELATIVE_VAR *pRelativeVar, Type &resultType, int *pss);

//MakeExe.cpp
void StepCompileProgress(void);
void DeleteConstInfo(CONSTINFO **ppConstHash);
void DeleteDeclareInfo(void);
void AddSourceCode(char *buffer);
void OutputExe(void);
int MainThread(DWORD dummy);

//Intermediate_Step1.cpp
void ChangeReturnCode(char *buffer);
void DeleteComment(char *buffer);
void KillReturnCode(char *buffer);
void CheckParenthesis(char *buffer);
BOOL CheckParenthesis2(char *buffer);
void DirectiveCheck(void);
void NextCommandFormat(char *buffer);
void SetEscapeSequenceFormat(char *buffer);
void DefCommandFormat(char *buffer);
void IfCommandFormat(char *buffer);
void CheckPareCommand(void);

//Intermediate_Step2.cpp
bool GetConstInfo(void);
void ChangeCommandToCode(char *buffer);

//preprocessor.cpp
char *OpenBasicFile(char *FileName);

//Resource.cpp
void GetResourceData(char *FileName);

//CommandFormat.cpp
void ComOpen(char *Parameter,char *buffer,int nowLine);
void ComClose(char *Parameter,char *buffer);
void ComField(char *Parameter,char *buffer);
void ComLine(char *Parameter,char *buffer,int nowLine);
void ComCircle(char *Parameter,char *buffer,int nowLine);
void ComPSet(char *Parameter,char *buffer,int nowLine);
void ComPaint(char *Parameter,char *buffer,int nowLine);

// StrOperation.cpp
void KillSpaces(char *str1,char *str2);
void KillStringSpaces(char *str);
BOOL RemoveStringQuotes(char *str);
void RemoveStringPare(char *str);
void RemoveStringBracket(char *str);
void SetStringQuotes(char *str);
int FormatString_EscapeSequence(char *buffer);
void SlideString(char *str,int slide);
void SlideBuffer(char *buffer,int length,int slide);
_int8 IsCommandDelimitation(char c);
BOOL IsBlank(char c);
int GetOneParameter(const char *Parameter,int pos,char *retAns);
int JumpOneParameter(char *Parameter,int i);
int GetStringInQuotation(char *buffer,char *ReadBuffer);
int GetStringInPare(char *buffer,const char *ReadBuffer);
int GetStringInPare_RemovePare(char *buffer,char *ReadBuffer);
int GetStringInBracket(char *buffer,const char *ReadBuffer);
int JumpStringInPare(const char *buffer,int pos);
int JumpStringInBracket(const char *buffer,int pos);
int GetCpFromLine(int LineNum);
BOOL GetLineNum(int pos,int *pLine,char *FileName);
char GetEndXXXCommand(char es);
void GetDefaultNameFromES(char es,char *name);
void GetCalcName(int idCalc,char *name);
BOOL IsFile(char *path);
BOOL ShortPathToLongPath(char ShortPath[MAX_PATH],char *LongPath);
BOOL GetFolder(HWND hWnd,char *folder,char *OpenFolderTitle);
void ShortPathToLongPath(const char *ShortPath,char *LongPath);

//calculation.cpp
bool IsNumberTopChar(const char *buffer);
bool IsNumberChar(const char c);
BOOL IsNumCalcMark(const char *Command,int p);
BOOL IsNumCalcMark_Back(const char *Command,int p);
BOOL IsStrCalcMark(const char c);
BOOL IsExponent(const char *Command,int p);
int GetLiteralIndex(_int64 i64data);
int NeutralizationType(int type1,LONG_PTR index1,int type2,LONG_PTR index2);
DWORD GetLiteralValue(char *value,_int64 *pi64,int BaseType);
BOOL GetConstCalcBuffer(const char *name,const char *Parameter,char *pCalcBuffer);
DWORD GetConstValue(char *name,double *dbl,char *buffer,LONG_PTR *plpIndex);
bool IsStringObjectType(const Type &TypeInfo);
int IsStrCalculation(char *Command);
BYTE GetCalcId(const char *Command,int *pi);
BOOL GetNumOpeElements(const char *Command,int *pnum,
					   char *values[255],long calc[255],long stack[255]);

//NumOpe_GetType.cpp
int AutoBigCast(int BaseType,int CalcType);
BOOL CheckCalcType(int idCalc,int *type,int sp);
bool NumOpe_GetType( const char *expression, const Type &baseType, Type &resultType );

//Subroutine.cpp
int GetCallProcName(char *buffer,char *name);
int GetProc(char *name,void **ppInfo);
void SplitObjectName(const char *name,char *ObjectName,int *pRefType);
bool SplitMemberName( const char *desc, char *object, char *member, CClass::RefType &refType );
bool SplitMemberName( const char *desc, char *object, char *member );
bool CallProc( int kind, const void *pProc, const char *fullCallName, const char *lpszParms, Type &resultType, bool isCallOn = true );
bool CallPropertyMethod( const char *variable, const char *rightSide, Type &resultType);
bool GetReturnTypeOfPropertyMethod( const char *variable, const char *rightSide, Type &resultType );
bool GetReturnTypeOfIndexerGetterProc( const CClass &objClass, Type &resultType );
GlobalProc *AddSubData( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, char *buffer,int nowLine,BOOL bVirtual,CClass *pobj_c, bool isStatic = false );
void GetSubInfo(void);
void DeleteSubInfo(GlobalProc **ppSubHash,char **ppMacroNames,int MacroNum);
void DeleteDeclareInfo(void);
int AddProcPtrInfo( const string &typeExpression, int nowLine );
void DeleteProcPtrInfo(void);
bool IsNeedProcCompile();

//OldStatement.cpp
void Opcode_Input(const char *Parameter);
void Opcode_Print(const char *Parameter,BOOL bWrite);

//LoopRefCheck.cpp
class CLoopRefCheck{
	char **names;
	int num;
	void init();
public:
	CLoopRefCheck();
	~CLoopRefCheck();
	void add(char *lpszInheritsClass);
	void del(char *lpszInheritsClass);
	BOOL check(const CClass &inheritsClass) const;
};
extern CLoopRefCheck *pobj_LoopRefCheck;

//DataTable.cpp
class DataTable{
	void *pdata;
	int size;

public:
	DataTable();
	~DataTable();
	void Init();

	int AddBinary( const void *pdata, int size );
	int Add( _int64 i64data );
	int Add( int i32data );
	int Add( double dbl );
	int Add( float flt );
	int AddString( const char *str, int length );
	int AddString( const char *str );

	const void *GetPtr() const;
	int GetSize() const;
};
extern DataTable dataTable;

//error.cpp
void SetError(int ErrorNum,const char *KeyWord,int pos);
void SetError(int ErrorNum,const string &keyWord,int pos);
void SetError();
void CompileMessage(char *buffer);
bool CheckDifferentType(const int VarType,const LONG_PTR lpVarIndex,const int CalcType,const LONG_PTR lpCalcIndex,const char *pszFuncName,const int ParmNum);
bool CheckDifferentType( const Type &varType,const Type &calcType,const char *pszFuncName,const int ParmNum);

//Compile.cpp
void ReallocNativeCodeBuffer();
void GetIdentifierToken( char *token, const char *source, int &pos );
int JumpStatement(const char *source, int &pos);
void DebugVariable(void);
void Compile(void);

//Diagnose.cpp
void Diagnose();

//gc.cpp
void InitGCVariables(void);
void PerformedGcVarSchedule(void);



#ifdef _DEBUG
/*Debug*/
/*
#define HeapAlloc CheckHeapAlloc
#define HeapReAlloc CheckHeapReAlloc
LPVOID CheckHeapAlloc(HANDLE hHeap,DWORD dwFlags,DWORD dwBytes);
LPVOID CheckHeapReAlloc(HANDLE hHeap,DWORD dwFlags,LPVOID lpMem,DWORD dwBytes);
*/
#endif
