#include "../BasicCompiler_Common/common.h"

#ifdef _AMD64_
#include "../BasicCompiler64/opcode.h"
#else
#include "../BasicCompiler32/opcode.h"
#endif

int hash_default(const char *name){
	int key;

	for(key=0;*name!='\0';name++){
		key=((key<<8)+ *name )%MAX_HASH;
	}

	return key;
}

CONSTINFO *GetConstHash(const char *name){
	//nbVl擾
	int key;
	key=hash_default(name);

	//i[ʒu擾
	extern CONSTINFO **ppConstHash;
	CONSTINFO *pci;
	pci=ppConstHash[key];
	while(pci){
		if(lstrcmp(pci->name,name)==0) break;

		pci=pci->pNextData;
	}

	return pci;
}

DllProc *GetDeclareHash(char *fullName){
	char ObjName[VN_SIZE];		//IuWFNgϐ
	char NestMember[VN_SIZE];	//qo
	bool isObjectMember = SplitMemberName( fullName, ObjName, NestMember );

	//nbVl擾
	int key;
	key=hash_default(NestMember);

	//i[ʒu擾
	extern DllProc **ppDeclareHash;
	DllProc *pDllProc;
	pDllProc=ppDeclareHash[key];
	while(pDllProc){
		// TODO: DeclareOԑΉ
		if( pDllProc->IsEqualSymbol( fullName ) ){
			break;
		}

		pDllProc=pDllProc->pNextData;
	}

	return pDllProc;
}

void GetOverloadSubHash( const char *lpszName, std::vector<UserProc *> &subs ){
	char name[VN_SIZE];

	if(lpszName[0]=='.'){
		GetWithName(name);
		lstrcat(name,lpszName);
	}
	else lstrcpy(name,lpszName);

	char ObjName[VN_SIZE];		//IuWFNgϐ
	char NestMember[VN_SIZE];	//qo
	bool isObjectMember = SplitMemberName( name, ObjName, NestMember );

	if(isObjectMember){
		//IuWFNg̃o֐̏ꍇ

		bool isStatic = false;
		const CClass *pobj_c = NULL;
		if(lstrcmpi(ObjName,"Super")==0){
			//NXo֐NX̌Ăяo
			pobj_c=pobj_CompilingClass;
		}
		else{
			//"->"ɂăIuWFNgw肷ʏ̃o֐Ăяo
			Type type;
			if( GetVarType(ObjName,type,0) ){
				pobj_c = &type.GetClass();
			}
			else{
				pobj_c=pobj_DBClass->Find(ObjName);
				if( pobj_c ){
					isStatic = true;
				}
			}
		}

		if( pobj_c && pobj_c != (CClass *)-1 ){
			if( isStatic ){
				// ÓI\bh
				pobj_c->EnumStaticMethod( NestMember, subs );
			}
			else{
				//I\bh
				pobj_c->EnumMethod( NestMember, subs );
			}
			return;
		}
	}


	if(pobj_CompilingClass){
		//g̃IuWFNg̃o֐

		// ÓI\bh
		pobj_CompilingClass->EnumStaticMethod( name, subs );

		// I\bh
		pobj_CompilingClass->EnumMethod( name, subs );
	}


	///////////////////////////
	// O[o֐
	///////////////////////////

	//nbVl擾
	int key;
	key=hash_default(NestMember);

	//i[ʒu擾
	extern GlobalProc **ppSubHash;
	GlobalProc *pUserProc;
	pUserProc=ppSubHash[key];
	while(pUserProc){
		if(!pUserProc->GetParentClassPtr()){
			if( pUserProc->IsEqualSymbol( name ) ){
				subs.push_back( pUserProc );
			}
		}

		pUserProc=pUserProc->pNextData;
	}
}

//I[o[[hĂȂ֐擾î̃RpC\[XR[hƂ̌݊ێj
UserProc *GetSubHash(const char *lpszName,BOOL bError){
	std::vector<UserProc *> subs;
	GetOverloadSubHash(lpszName,subs);

	//֐݂ȂƂ
	if(subs.size() == 0){
		if(bError){
			SetError(3,lpszName,cp);
		}
		return 0;
	}

	//ȏ̊֐݂Ƃ͓G[ifobOpj
	if(subs.size() > 1){
		if(bError) SetError(300,NULL,cp);
	}

	UserProc *pUserProc;
	pUserProc = subs[0];

	return pUserProc;
}
UserProc *GetMethodHash(const char *ObjectName,const char *MethodName,const char *Parameter,BOOL bError){
	char temporary[VN_SIZE];
	sprintf(temporary,"%s.%s",ObjectName,MethodName);

	std::vector<UserProc *> subs;
	UserProc *pUserProc;
	GetOverloadSubHash(temporary,subs);

	//֐݂ȂƂ
	if(subs.size() == 0){
		return 0;
	}

	//I[o[[h
	pUserProc=OverloadSolutionWithStrParam(temporary,subs,Parameter,ObjectName);

	return pUserProc;
}

UserProc *GetClassMethod( const char *className, const char *methodName ){
	CClass *pClass = pobj_DBClass->Find( className );
	if( pClass ){
		vector<UserProc *> userProcs;
		pClass->EnumMethod( methodName, userProcs );
		if( userProcs.size() == 1 ){
			return userProcs[0];
		}
	}

	char temporary[VN_SIZE];
	sprintf( temporary, "%s.%s", className, methodName );
	SetError(3, temporary, -1 );

	return NULL;
}
