#include "Common.h"


void ScreenToClient(HWND hwnd,RECT *pRect){
	ScreenToClient(hwnd,(POINT *)pRect);
	ScreenToClient(hwnd,(POINT *)(((long)(void *)pRect)+sizeof(POINT)));
}
void ClientToScreen(HWND hwnd,RECT *pRect){
	ClientToScreen(hwnd,(POINT *)pRect);
	ClientToScreen(hwnd,(POINT *)(((long)(void *)pRect)+sizeof(POINT)));
}


typedef BOOL (WINAPI *LPFN_ISWOW64PROCESS) (HANDLE hProcess,PBOOL Wow64Process);
BOOL IsWow64(void){
	///////////////////////////////////////////////////////////
	// ProjectEditor.exeWOW64Zpœ삵Ă̂ǂ
	///////////////////////////////////////////////////////////
	BOOL bIsWow64 = FALSE;
	LPFN_ISWOW64PROCESS fnIsWow64Process = (LPFN_ISWOW64PROCESS)GetProcAddress(GetModuleHandle("kernel32"),"IsWow64Process");

	if (NULL != fnIsWow64Process)
	{
		if (!fnIsWow64Process(GetCurrentProcess(),&bIsWow64))
		{
			// handle error
			bIsWow64 = FALSE;
		}
	}
	return bIsWow64;
}

void URLEncode(LPSTR pszSrc){
	char *temp;
	temp=(char *)malloc(65535);

	int i,i2;
	for (i = 0,i2=0; ; i++,i2++)
	{
		if(pszSrc[i]=='\0'){
			temp[i2] = 0;
			break;
		}

		// p _ . - ͕ϊȂł̂܂
		if (isalnum((BYTE)pszSrc[i]) || pszSrc[i] == '_' || pszSrc[i] == '.' || pszSrc[i] == '-'){
			temp[i2] = pszSrc[i];
		}
		// ȊO %3B ̂悤Ȍ`ɕϊ
		else{
			sprintf(temp+i2,"%%%02X", (BYTE)pszSrc[i]);
			i2+=lstrlen(temp+i2);
			i2--;
		}
	}

	lstrcpy(pszSrc,temp);
	free(temp);
}

void Digit(int num,char *buffer){
	char temporary[255];
	int i,iPos;

	sprintf(temporary,"%d",abs(num));

	//J}sv̏ꍇ͔
	if(lstrlen(temporary)<=3){
		wsprintf(buffer,"%d",num);
		return;
	}

	//v̕obt@m
	if(num<0){
		buffer[0]='-';
		iPos=1;
	}
	else{
		buffer[0]=0;
		iPos=0;
	}

	//3ɃJ}Ȃ當Rs[
	int iFirst;
	iFirst=lstrlen(temporary)%3;
	if(iFirst==0) iFirst=3;
	memcpy(buffer+iPos,temporary,iFirst);
	iPos+=iFirst;

	int i2;
	i2=(lstrlen(temporary)-4)/3;

	for(i=0;i<=i2;i++){
		buffer[iPos]=',';
		iPos++;
		memcpy(buffer+iPos,temporary+i*3+iFirst,3);
		iPos+=3;
		buffer[iPos]=0;
	}
}

void RectNaturalFormat(RECT *ReadRect,RECT *CopyRect){
	if(ReadRect->left > ReadRect->right){
		CopyRect->left=ReadRect->right;
		CopyRect->right=ReadRect->left;
	}
	else{
		CopyRect->left=ReadRect->left;
		CopyRect->right=ReadRect->right;
	}
	if(ReadRect->top > ReadRect->bottom){
		CopyRect->top=ReadRect->bottom;
		CopyRect->bottom=ReadRect->top;
	}
	else{
		CopyRect->top=ReadRect->top;
		CopyRect->bottom=ReadRect->bottom;
	}
}
void RectNaturalFormat(int *x1,int *y1,int *x2,int *y2){
	int temp;
	if(*x1>*x2){
		temp=*x1;
		*x1=*x2;
		*x2=temp;
	}
	if(*y1>*y2){
		temp=*y1;
		*y1=*y2;
		*y2=temp;
	}
}
void KillSpaces(char *str1,char *str2){
	int i,i2,IsStr;
	for(i=0,i2=0,IsStr=0;;i++,i2++){
		while((str1[i]==' '||str1[i]=='\t')&&IsStr==0&&str1[i]!='\0') i++;
		if(str1[i]=='\"') IsStr^=1;
		str2[i2]=str1[i];
		if(str1[i]=='\0') break;
	}
}
void RemoveStringQuotes(char *str){
	int i;
	if(str[0]!='\"') return;
	for(i=0;;i++){
		str[i]=str[i+1];
		if(str[i]=='\"') break;
	}
	str[i]=0;
}
void SlideString(char *buffer, int slide){
	char *temp;
	temp=(char *)malloc(lstrlen(buffer)+1);
	lstrcpy(temp,buffer);
	lstrcpy(buffer+slide,temp);
	free(temp);
}
void SlideBuffer(char *buffer,int length,int slide){
	void *temp;
	temp=malloc(length+1);
	memcpy(temp,buffer,length);
	memcpy(buffer+slide,temp,length);
	free(temp);
}
BOOL IsVariableTopChar(char c){
	if((c>='A'&&c<='Z')||(c>='a'&&c<='z')||c=='_') return 1;
	return 0;
}
bool IsNumberChar( char c ){
	if(c>='0'&&c<='9'){
		return true;
	}
	return false;
}
BOOL IsVariableChar(char c){
	if((c>='A'&&c<='Z')||(c>='a'&&c<='z')||(c>='0'&&c<='9')||
		c=='_'||c=='.'||c=='$') return 1;
	return 0;
}

BOOL IsCommandBackDelimitation(char *buffer,int pos){
	if(buffer[pos]=='\n'||buffer[pos]==':') return 1;
	return 0;
}
BOOL IsCommandDelimitation(char *buffer,int p){
	if(buffer[p]=='\r'&&buffer[p+1]=='\n') return 2;
	if(buffer[p]=='\n'||buffer[p]==':'||buffer[p]=='\0') return 1;
	return 0;
}

char *ComparisonString( char *str1, char *str2, bool isBigSmall, bool isWordUnit ){
	char *temp1 = (char *)malloc( lstrlen( str1 ) +1 );
	char *temp2 = (char *)malloc( lstrlen( str2 ) +1 );

	lstrcpy( temp1, str1 );
	lstrcpy( temp2, str2 );

	if( isBigSmall == false ){
		// 啶ʂȂꍇ
		// ׂđ啶ɂĂ
		CharUpper( temp1 );
		CharUpper( temp2 );
	}

	int len2 = lstrlen( temp2 );

	const char *temp3 = strstr( temp1, temp2 );
	while( temp3 ){
		if( isWordUnit ){
			int pos = (int)temp3 - (int)temp1;
			if( pos == 0 ){
				if( !( IsVariableTopChar( temp1[len2] ) || IsNumberChar( temp1[len2] ) ) ){
						break;
				}
			}
			else{
				if( !( IsVariableTopChar( temp1[pos-1] ) || IsNumberChar( temp1[pos-1] ) )
					&& !( IsVariableTopChar( temp1[pos+len2] ) || IsNumberChar( temp1[pos+len2] ) )
					){
						break;
				}
			}
		}
		else{
			break;
		}

		temp3 = strstr( temp3 + 1, temp2 );
	}

	char *result = NULL;
	if( temp3 ){
		int pos = (int)temp3 - (int)temp1;
		result = str1 + pos;
	}

	free( temp1 );
	free( temp2 );

	return result;
}
int GetOneParameter(char *Parameter,int pos,char *retAns){
	int i,i2,IsStr,PareNum;
	for(i=pos,i2=0,IsStr=0,PareNum=0;;i++,i2++){
		if(IsDBCSLeadByte(Parameter[i])){
			retAns[i2]=Parameter[i];
			retAns[++i2]=Parameter[++i];
			continue;
		}
		if(Parameter[i]=='\"') IsStr^=1;
		if(Parameter[i]=='('&&IsStr==0) PareNum++;
		if(Parameter[i]==')'&&IsStr==0) PareNum--;
		if(Parameter[i]==','&&IsStr==0&&PareNum==0){
			retAns[i2]=0;
			break;
		}
		retAns[i2]=Parameter[i];
		if(Parameter[i]=='\0'||Parameter[i]=='\r'&&Parameter[i+1]=='\n'){
			retAns[i2]=0;
			break;
		}
	}
	if(Parameter[i]==',') i++;
	return i;
}
int GetStringInPare(char *buffer,char *ReadBuffer){
	int i,IsStr,PareNum;
	for(i=0,IsStr=0,PareNum=0;;i++){
		buffer[i]=ReadBuffer[i];
		if(ReadBuffer[i]=='\"') IsStr^=1;
		else if(ReadBuffer[i]=='('&&IsStr==0) PareNum++;
		else if(ReadBuffer[i]==')'&&IsStr==0){
			PareNum--;
			if(PareNum==0){
				i++;
				buffer[i]=0;
				break;
			}
		}
		else if(ReadBuffer[i]=='\0') return 0;
	}
	return i;
}
int GetStringInBracket(char *buffer,char *ReadBuffer){
	int i,IsStr,PareNum;
	for(i=0,IsStr=0,PareNum=0;;i++){
		buffer[i]=ReadBuffer[i];
		if(IsDBCSLeadByte(ReadBuffer[i])){
			i++;
			buffer[i]=ReadBuffer[i];
			continue;
		}
		if(ReadBuffer[i]=='\"') IsStr^=1;
		else if(ReadBuffer[i]=='['&&IsStr==0) PareNum++;
		else if(ReadBuffer[i]==']'&&IsStr==0){
			PareNum--;
			if(PareNum==0){
				i++;
				buffer[i]=0;
				break;
			}
		}
		else if(ReadBuffer[i]=='\0') return 0;
	}
	return i;
}
void JumpBlank(char *pBuf,int *piPos){
	int i;
	i=*piPos;

	while(1){
		while(pBuf[i]==' '||pBuf[i]=='\t') i++;
		if(pBuf[i]=='\0') break;
		if(pBuf[i]=='\''){
			//ߕisj
			for(i++;;i++){
				if(pBuf[i]=='\0') break;
				if(pBuf[i]=='\r'&&pBuf[i+1]=='\n'){
					i+=2;
					break;
				}
			}
			while(pBuf[i]==' '||pBuf[i]=='\t') i++;
		}
		if(pBuf[i]=='/'&&pBuf[i+1]=='*'){
			//ߕisj
			i+=2;
			while(!(pBuf[i]=='*'&&pBuf[i+1]=='/')){
				i++;
				if(pBuf[i]=='\0') break;
			}
			if(pBuf[i]){
				i+=2;
			}
		}
		while(pBuf[i]=='\r'&&pBuf[i+1]=='\n') i+=2;

		if(!(
			pBuf[i]==' '||
			pBuf[i]=='\t'||
			pBuf[i]=='\''||
			(pBuf[i]=='/'&&pBuf[i+1]=='*')
			)) break;
	}

	*piPos=i;
}

BOOL CheckParenthesis(char *buffer){
	int i,IsStr,PareNum,sw;
	_int8 bracket[1024];

	for(i=0,IsStr=0,PareNum=0,sw=0;;i++){
		if(buffer[i]=='\"'){
			IsStr^=1;
			continue;
		}

		else if(buffer[i]=='('&&IsStr==0){
			bracket[PareNum]=0;
			PareNum++;
		}
		else if(buffer[i]=='['&&IsStr==0){
			bracket[PareNum]=1;
			PareNum++;
		}

		else if(buffer[i]==')'&&IsStr==0){
			PareNum--;
			if(bracket[PareNum]!=0||PareNum<0){
				//"JbR \'( )\'"
				return 0;
			}
		}
		else if(buffer[i]==']'&&IsStr==0){
			PareNum--;
			if(bracket[PareNum]!=1||PareNum<0){
				//"JbR \'( )\'"
				return 0;
			}
		}

		else if(buffer[i]=='\n'||buffer[i]=='\0'){

			//"JbR \'( )\'"
			if(buffer[i]=='\0'){
				if(PareNum!=0){
					return 0;
				}

				if(IsStr!=0){
					return 0;
				}
			}
			if(buffer[i]=='\0') break;

			sw=0;
		}
	}
	return 1;
}

DWORD GetValue(char *value){
	unsigned long ans;
	if(value[0]=='&'){
		if(value[1]=='o'||value[1]=='O') sscanf(value+2,"%o",&ans);
		if(value[1]=='h'||value[1]=='H') sscanf(value+2,"%x",&ans);
	}
	else ans=atol(value);
	return ans;
}
BOOL IsManagementCommand(int ComNum){
	switch(ComNum){
		case -1:
		case COM_ABSTRACT:
		case COM_CLASS:
		case COM_CONST:
		case COM_DEBUG:
		case COM_DECLARE:
		case COM_DEF:
		case COM_DIM:
		case COM_DO:
		case COM_END:
		case COM_ENUM:
		case COM_FOR:
		case COM_FUNCTION:
		case COM_GOSUB:
		case COM_GOTO:
		case COM_IF:
		case COM_INHERITS:
		case COM_INTERFACE:
		case COM_LOOP:
		case COM_NEXT:
		case COM_PRIVATE:
		case COM_PROTECTED:
		case COM_PUBLIC:
		case COM_RETURN:
		case COM_SELECT:
		case COM_SUB:
		case COM_TYPE:
		case COM_TYPEDEF:
		case COM_VIRTUAL:
		case COM_OVERRIDE:
		case COM_WEND:
		case COM_WHILE:
		case COM_WITH:
			return 1;
		default:
			break;
	}
	return 0;
}
int IsBasicReservedWord(char *str){
	if(str[0]=='a'||str[0]=='A'){
		if(lstrcmpi(str,"Abstract")==0) return COM_ABSTRACT;
		if(lstrcmpi(str,"As")==0) return -1;
	}
	else if(str[0]=='b'||str[0]=='B'){
		if(lstrcmpi(str,"Beep")==0) return COM_BEEP;
		if(lstrcmp(str,"Boolean")==0) return -1;
		if(lstrcmpi(str,"ByRef")==0) return -1;
		if(lstrcmpi(str,"ByVal")==0) return -1;
		if(lstrcmp(str,"Byte")==0) return -1;
	}
	else if(str[0]=='c'||str[0]=='C'){
		if(lstrcmpi(str,"Case")==0) return -1;
		if(lstrcmp(str,"Char")==0) return -1;
		if(lstrcmpi(str,"ChDir")==0) return COM_CHDIR;
		if(lstrcmpi(str,"Circle")==0) return COM_CIRCLE;
		if(lstrcmpi(str,"Class")==0) return COM_CLASS;
		if(lstrcmpi(str,"Close")==0) return COM_CLOSE;
		if(lstrcmpi(str,"Cls")==0) return COM_CLS;
		if(lstrcmpi(str,"Color")==0) return COM_COLOR;
		if(lstrcmpi(str,"Const")==0) return COM_CONST;
		if(lstrcmpi(str,"Continue")==0) return -1;
	}
	else if(str[0]=='d'||str[0]=='D'){
		if(lstrcmpi(str,"Debug")==0) return COM_DEBUG;
		if(lstrcmpi(str,"Declare")==0) return COM_DECLARE;
		if(lstrcmpi(str,"Def")==0) return COM_DEF;
		if(lstrcmpi(str,"Delete")==0) return -1;
		if(lstrcmpi(str,"DelWnd")==0) return COM_DELWND;
		if(lstrcmpi(str,"Dim")==0) return COM_DIM;
		if(lstrcmpi(str,"Do")==0) return COM_DO;
		if(lstrcmp(str,"Double")==0) return -1;
		if(lstrcmp(str,"DWord")==0) return -1;
	}
	else if(str[0]=='e'||str[0]=='E'){
		if(lstrcmpi(str,"Else")==0) return -1;
		if(lstrcmpi(str,"ElseIf")==0) return -1;
		if(lstrcmpi(str,"End")==0) return COM_END;
		if(lstrcmpi(str,"EndIf")==0) return -1;
		if(lstrcmpi(str,"EndFunction")==0) return -1;
		if(lstrcmpi(str,"EndSub")==0) return -1;
		if(lstrcmpi(str,"EndType")==0) return -1;
		if(lstrcmpi(str,"EndSelect")==0) return -1;
		if(lstrcmpi(str,"EndWith")==0) return -1;
		if(lstrcmpi(str,"Enum")==0) return COM_ENUM;
		if(lstrcmpi(str,"Exit")==0) return -1;
		if(lstrcmpi(str,"ExitDo")==0) return -1;
		if(lstrcmpi(str,"ExitFor")==0) return -1;
		if(lstrcmpi(str,"ExitFunction")==0) return -1;
		if(lstrcmpi(str,"ExitSub")==0) return -1;
		if(lstrcmpi(str,"ExitWhile")==0) return -1;
	}
	else if(str[0]=='f'||str[0]=='F'){
		if(lstrcmp(str,"False")==0) return -1;
		if(lstrcmpi(str,"Field")==0) return COM_FIELD;
		if(lstrcmpi(str,"For")==0) return COM_FOR;
		if(lstrcmpi(str,"Function")==0) return COM_FUNCTION;
	}
	else if(str[0]=='g'||str[0]=='G'){
		if(lstrcmpi(str,"Get")==0) return COM_GET;
		if(lstrcmpi(str,"GoSub")==0) return COM_GOSUB;
		if(lstrcmpi(str,"Goto")==0) return COM_GOTO;
	}
	else if(str[0]=='i'||str[0]=='I'){
		if(lstrcmpi(str,"If")==0) return COM_IF;
		if(lstrcmpi(str,"Imports")==0) return -1;
		if(lstrcmpi(str,"Inherits")==0) return COM_INHERITS;
		if(lstrcmpi(str,"Input")==0) return COM_INPUT;
		if(lstrcmp(str,"Int64")==0) return -1;
		if(lstrcmp(str,"Integer")==0) return -1;
		if(lstrcmpi(str,"Interface")==0) return COM_INTERFACE;
	}
	else if(str[0]=='k'||str[0]=='K'){
		if(lstrcmpi(str,"Kill")==0) return COM_KILL;
	}
	else if(str[0]=='l'||str[0]=='L'){
		if(lstrcmpi(str,"Let")==0) return COM_LET;
		if(lstrcmpi(str,"Line")==0) return COM_LINE;
		if(lstrcmpi(str,"Locate")==0) return COM_LOCATE;
		if(lstrcmp(str,"Long")==0) return -1;
		if(lstrcmpi(str,"Loop")==0) return COM_LOOP;
	}
	else if(str[0]=='m'||str[0]=='M'){
		if(lstrcmpi(str,"MkDir")==0) return COM_MKDIR;
		if(lstrcmpi(str,"MsgBox")==0) return COM_MSGBOX;
	}
	else if(str[0]=='n'||str[0]=='N'){
		if(lstrcmpi(str,"Namespace")==0) return -1;
		if(lstrcmpi(str,"Next")==0) return COM_NEXT;
		if(lstrcmpi(str,"New")==0) return -1;
		if(lstrcmpi(str,"Nothing")==0) return -1;
	}
	else if(str[0]=='o'||str[0]=='O'){
		if(lstrcmpi(str,"Open")==0) return COM_OPEN;
		if(lstrcmpi(str,"Operator")==0) return -1;
		if(lstrcmpi(str,"Override")==0) return COM_OVERRIDE;
	}
	else if(str[0]=='p'||str[0]=='P'){
		if(lstrcmpi(str,"Paint")==0) return COM_PAINT;
		if(lstrcmpi(str,"Print")==0) return COM_PRINT;
		if(lstrcmpi(str,"Private")==0) return COM_PRIVATE;
		if(lstrcmpi(str,"Protected")==0) return COM_PROTECTED;
		if(lstrcmpi(str,"PSet")==0) return COM_PSET;
		if(lstrcmpi(str,"Put")==0) return COM_PUT;
		if(lstrcmpi(str,"Public")==0) return COM_PUBLIC;
	}
	else if(str[0]=='q'||str[0]=='Q'){
		if(lstrcmp(str,"QWord")==0) return -1;
	}
	else if(str[0]=='r'||str[0]=='R'){
		if(lstrcmpi(str,"Randomize")==0) return COM_RANDOMIZE;
		if(lstrcmpi(str,"Rem")==0) return COM_REM;
		if(lstrcmpi(str,"Return")==0) return COM_RETURN;
	}
	else if(str[0]=='s'||str[0]=='S'){
		if(lstrcmp(str,"SByte")==0) return -1;
		if(lstrcmpi(str,"Select")==0) return COM_SELECT;
		if(lstrcmpi(str,"SelectCase")==0) return COM_SELECT;
		if(lstrcmp(str,"Single")==0) return -1;
		if(lstrcmpi(str,"Sleep")==0) return COM_SLEEP;
		if(lstrcmpi(str,"Static")==0) return -1;
		if(lstrcmpi(str,"Sub")==0) return COM_SUB;
		if(lstrcmpi(str,"Super")==0) return -1;
	}
	else if(str[0]=='t'||str[0]=='T'){
		if(lstrcmpi(str,"Then")==0) return -1;
		if(lstrcmpi(str,"This")==0) return -1;
		if(lstrcmp(str,"True")==0) return -1;
		if(lstrcmpi(str,"Type")==0) return COM_TYPE;
		if(lstrcmpi(str,"TypeDef")==0) return COM_TYPEDEF;
	}
	else if(str[0]=='u'||str[0]=='U'){
		if(lstrcmpi(str,"Until")==0) return -1;
	}
	else if(str[0]=='v'||str[0]=='V'){
		if(lstrcmpi(str,"Virtual")==0) return COM_VIRTUAL;
	}
	else if(str[0]=='w'||str[0]=='W'){
		if(lstrcmpi(str,"Wend")==0) return COM_WEND;
		if(lstrcmpi(str,"While")==0) return COM_WHILE;
		if(lstrcmpi(str,"Window")==0) return COM_WINDOW;
		if(lstrcmpi(str,"With")==0) return COM_WITH;
		if(lstrcmp(str,"Word")==0) return -1;
		if(lstrcmpi(str,"Write")==0) return COM_WRITE;
	}
	else if(str[0]=='#'){
		if(lstrcmpi(str,"#include")==0) return -1;
		if(lstrcmpi(str,"#strict")==0) return -1;
		if(lstrcmpi(str,"#console")==0) return -1;
		if(lstrcmpi(str,"#prompt")==0) return -1;
		if(lstrcmpi(str,"#N88BASIC")==0) return -1;
		if(lstrcmpi(str,"#define")==0) return -1;
		if(lstrcmpi(str,"#ifdef")==0) return -1;
		if(lstrcmpi(str,"#ifndef")==0) return -1;
		if(lstrcmpi(str,"#else")==0) return -1;
		if(lstrcmpi(str,"#endif")==0) return -1;
	}
	return 0;
}

HBITMAP CreateGradationBitmap(SIZE *pSize,COLORREF color1,COLORREF color2){
	//Of[Vrbg}bv𐶐

	BITMAPINFO BitmapInfo;
	memset(&BitmapInfo.bmiHeader,0,sizeof(BITMAPINFOHEADER));
	BitmapInfo.bmiHeader.biSize=sizeof(BITMAPINFOHEADER);
	BitmapInfo.bmiHeader.biWidth=pSize->cx;
	BitmapInfo.bmiHeader.biHeight=pSize->cy;
	BitmapInfo.bmiHeader.biPlanes=1;
	BitmapInfo.bmiHeader.biBitCount=24;

	HDC hdc;
	hdc=GetDC(GetDesktopWindow());

	HBITMAP hBitmap;
	BYTE *pByte;
	hBitmap=CreateDIBSection(hdc,&BitmapInfo,DIB_RGB_COLORS,(void **)&pByte,0,0);

	int i,i2,x,y;
	COLORREF rgb;
	i=BitmapInfo.bmiHeader.biWidth*3;
	if(i%sizeof(LONG)!=0) i+=sizeof(LONG)-(i%sizeof(LONG));
	for(y=0;y<BitmapInfo.bmiHeader.biHeight;y++){
		if(y<BitmapInfo.bmiHeader.biHeight/2-2) rgb=color2;
		else if(y>BitmapInfo.bmiHeader.biHeight/2+2) rgb=color1;
		else{
			double ratio;
			ratio=((double)y-((double)BitmapInfo.bmiHeader.biHeight/(double)2-(double)2))/(double)4;
			//ratio=(double)y/(double)BitmapInfo.bmiHeader.biHeight;
			rgb=RGB(
				LOBYTE(LOWORD(color2))+(int)(double)(LOBYTE(LOWORD(color1))-LOBYTE(LOWORD(color2)))*(ratio),	//ԗvf
				HIBYTE(LOWORD(color2))+(int)(double)(HIBYTE(LOWORD(color1))-HIBYTE(LOWORD(color2)))*(ratio),	//Ηvf
				LOBYTE(HIWORD(color2))+(int)(double)(LOBYTE(HIWORD(color1))-LOBYTE(HIWORD(color2)))*(ratio)		//vf
				);
		}
		for(x=0;x<BitmapInfo.bmiHeader.biWidth;x++){
			i2=y*i+x*3;
			pByte[i2+2]=LOBYTE(LOWORD(rgb));
			pByte[i2+1]=HIBYTE(LOWORD(rgb));
			pByte[i2]=LOBYTE(HIWORD(rgb));
		}
	}

	ReleaseDC(GetDesktopWindow(),hdc);

	return hBitmap;
}
HBITMAP CreateVertGradationBitmap(SIZE *pSize,COLORREF color1,COLORREF color2){
	//Of[Vrbg}bv𐶐

	BITMAPINFO BitmapInfo;
	memset(&BitmapInfo.bmiHeader,0,sizeof(BITMAPINFOHEADER));
	BitmapInfo.bmiHeader.biSize=sizeof(BITMAPINFOHEADER);
	BitmapInfo.bmiHeader.biWidth=pSize->cx;
	BitmapInfo.bmiHeader.biHeight=pSize->cy;
	BitmapInfo.bmiHeader.biPlanes=1;
	BitmapInfo.bmiHeader.biBitCount=24;

	HDC hdc;
	hdc=GetDC(GetDesktopWindow());

	HBITMAP hBitmap;
	BYTE *pByte;
	hBitmap=CreateDIBSection(hdc,&BitmapInfo,DIB_RGB_COLORS,(void **)&pByte,0,0);

	int i,i2,x,y;
	COLORREF rgb;
	i=BitmapInfo.bmiHeader.biWidth*3;
	if(i%sizeof(LONG)!=0) i+=sizeof(LONG)-(i%sizeof(LONG));
	for(y=0;y<BitmapInfo.bmiHeader.biHeight;y++){
		if(y<BitmapInfo.bmiHeader.biHeight/2-2) rgb=color2;
		else if(y>BitmapInfo.bmiHeader.biHeight/2+2) rgb=color1;
		else{
			double ratio;
			ratio=(double)y/(double)BitmapInfo.bmiHeader.biHeight;
			rgb=RGB(
				LOBYTE(LOWORD(color2))+(int)(double)(LOBYTE(LOWORD(color1))-LOBYTE(LOWORD(color2)))*(ratio),	//ԗvf
				HIBYTE(LOWORD(color2))+(int)(double)(HIBYTE(LOWORD(color1))-HIBYTE(LOWORD(color2)))*(ratio),	//Ηvf
				LOBYTE(HIWORD(color2))+(int)(double)(LOBYTE(HIWORD(color1))-LOBYTE(HIWORD(color2)))*(ratio)		//vf
				);
		}
		for(x=0;x<BitmapInfo.bmiHeader.biWidth;x++){
			i2=y*i+x*3;
			pByte[i2+2]=LOBYTE(LOWORD(rgb));
			pByte[i2+1]=HIBYTE(LOWORD(rgb));
			pByte[i2]=LOBYTE(HIWORD(rgb));
		}
	}

	ReleaseDC(GetDesktopWindow(),hdc);

	return hBitmap;
}
HBITMAP CreateHorzGradationBitmap(SIZE *pSize,COLORREF color1,COLORREF color2){
	//Of[Vrbg}bv𐶐

	BITMAPINFO BitmapInfo;
	memset(&BitmapInfo.bmiHeader,0,sizeof(BITMAPINFOHEADER));
	BitmapInfo.bmiHeader.biSize=sizeof(BITMAPINFOHEADER);
	BitmapInfo.bmiHeader.biWidth=pSize->cx;
	BitmapInfo.bmiHeader.biHeight=pSize->cy;
	BitmapInfo.bmiHeader.biPlanes=1;
	BitmapInfo.bmiHeader.biBitCount=24;

	HDC hdc;
	hdc=GetDC(GetDesktopWindow());

	HBITMAP hBitmap;
	BYTE *pByte;
	hBitmap=CreateDIBSection(hdc,&BitmapInfo,DIB_RGB_COLORS,(void **)&pByte,0,0);

	int i,i2,x,y;
	COLORREF rgb;
	i=BitmapInfo.bmiHeader.biWidth*3;
	if(i%sizeof(LONG)!=0) i+=sizeof(LONG)-(i%sizeof(LONG));
	for(x=0;x<BitmapInfo.bmiHeader.biWidth;x++){
		double ratio;
		ratio=(double)x/(double)BitmapInfo.bmiHeader.biWidth;
		rgb=RGB(
			LOBYTE(LOWORD(color1))+(int)(double)(LOBYTE(LOWORD(color2))-LOBYTE(LOWORD(color1)))*(ratio),	//ԗvf
			HIBYTE(LOWORD(color1))+(int)(double)(HIBYTE(LOWORD(color2))-HIBYTE(LOWORD(color1)))*(ratio),	//Ηvf
			LOBYTE(HIWORD(color1))+(int)(double)(LOBYTE(HIWORD(color2))-LOBYTE(HIWORD(color1)))*(ratio)		//vf
			);
		for(y=0;y<BitmapInfo.bmiHeader.biHeight;y++){
			i2=y*i+x*3;
			pByte[i2+2]=LOBYTE(LOWORD(rgb));
			pByte[i2+1]=HIBYTE(LOWORD(rgb));
			pByte[i2]=LOBYTE(HIWORD(rgb));
		}
	}

	ReleaseDC(GetDesktopWindow(),hdc);

	return hBitmap;
}
HICON CreateGrayIcon(HICON hBaseIcon){
	////////////////////////
	// WFACR𐶐
	////////////////////////

	HICON hGrayIcon;

	ICONINFO IconInfo;
	GetIconInfo(hBaseIcon,&IconInfo);


	//rbg}bvH
	BITMAP Bitmap;
	GetObject(IconInfo.hbmColor,sizeof(Bitmap),&Bitmap);

	BITMAPINFO BitmapInfo;
	memset(&BitmapInfo.bmiHeader,0,sizeof(BITMAPINFOHEADER));
	BitmapInfo.bmiHeader.biSize=sizeof(BITMAPINFOHEADER);
	BitmapInfo.bmiHeader.biWidth=Bitmap.bmWidth;
	BitmapInfo.bmiHeader.biHeight=Bitmap.bmHeight;
	BitmapInfo.bmiHeader.biPlanes=1;
	BitmapInfo.bmiHeader.biBitCount=24;
	BitmapInfo.bmiHeader.biCompression=BI_RGB;

	HDC hdc;
	hdc=GetDC(GetDesktopWindow());

	BYTE *pByte;
	pByte=(BYTE *)HeapAlloc(hHeap,0,Bitmap.bmWidth*Bitmap.bmHeight*sizeof(COLORREF));
	GetDIBits(hdc,
		IconInfo.hbmColor,
		0,
		Bitmap.bmHeight,
		(void *)pByte,
		&BitmapInfo,
		DIB_RGB_COLORS);

	int i,i2,x,y;
	i=BitmapInfo.bmiHeader.biWidth*3;
	if(i%sizeof(LONG)!=0) i+=sizeof(LONG)-(i%sizeof(LONG));
	for(x=0;x<BitmapInfo.bmiHeader.biWidth;x++){
		for(y=0;y<BitmapInfo.bmiHeader.biHeight;y++){
			i2=y*i+x*3;
			if(pByte[i2+2]==0&&pByte[i2+1]==0&&pByte[i2]==0){
				//F
				//Ȃ
			}
			else{
				double ratio=0.5;	//邳

				pByte[i2+2]+=(BYTE)((double)(255-pByte[i2+2])*ratio);
				pByte[i2+1]+=(BYTE)((double)(255-pByte[i2+1])*ratio);
				pByte[i2]+=(BYTE)((double)(255-pByte[i2])*ratio);

				pByte[i2+2]=(BYTE)(((int)pByte[i2+2]+(int)pByte[i2+1]+(int)pByte[i2])/3);
				pByte[i2+1]=pByte[i2+2];
				pByte[i2]=pByte[i2+2];
			}
		}
	}

	SetDIBits(hdc,
		IconInfo.hbmColor,
		0,
		Bitmap.bmHeight,
		(void *)pByte,
		&BitmapInfo,
		DIB_RGB_COLORS);

	HeapDefaultFree(pByte);

	ReleaseDC(GetDesktopWindow(),hdc);


	hGrayIcon=CreateIconIndirect(&IconInfo);

	//svȃrbg}bvj
	DeleteObject(IconInfo.hbmMask);
	DeleteObject(IconInfo.hbmColor);

	return hGrayIcon;
}
void GetSize(SIZE *pSize,RECT *pRect){
	pSize->cx=pRect->right-pRect->left;
	pSize->cy=pRect->bottom-pRect->top;
}
BOOL HitTest(RECT *pRect,POINT *pPos){
	if(pRect->left<=pPos->x&&pPos->x<pRect->right&&
		pRect->top<=pPos->y&&pPos->y<pRect->bottom) return 1;
	return 0;
}
BOOL Rectangle(HDC hdc,RECT *pRect){
	return Rectangle(hdc,pRect->left,pRect->top,pRect->right,pRect->bottom);
}

void ComboBox_SetSelText(HWND hCombo,char *lpszText){
	SendMessage(hCombo,CB_SETCURSEL,
		SendMessage(hCombo,CB_FINDSTRINGEXACT,0,(LPARAM)lpszText),
		0);
}

void SetCursorByState(int state){
	if(state==FRAME_UPPER_LEFT||state==FRAME_LOWER_RIGHT) SetCursor(LoadCursor(0,IDC_SIZENWSE));
	else if(state==FRAME_UPPER_RIGHT||state==FRAME_LOWER_LEFT) SetCursor(LoadCursor(0,IDC_SIZENESW));
	else if(state==FRAME_LEFT||state==FRAME_RIGHT) SetCursor(LoadCursor(0,IDC_SIZEWE));
	else if(state==FRAME_UPPER||state==FRAME_LOWER) SetCursor(LoadCursor(0,IDC_SIZENS));
	else if(state==FRAME_INSIDE) SetCursor(LoadCursor(0,IDC_SIZEALL));
	else SetCursor(LoadCursor(0,IDC_ARROW));
}

void SetTextEditColorDesign(TEXTEDIT_COLOR_INFO *pColorInfo,CTheme *pobj_Theme,BOOL bRedraw){
	pColorInfo->rgbDefault=pobj_Theme->TextColorInfo.rgbDefault;
	pColorInfo->rgbComment=pobj_Theme->TextColorInfo.rgbComment;
	pColorInfo->rgbStatement=pobj_Theme->TextColorInfo.rgbStatement;
	pColorInfo->rgbString=pobj_Theme->TextColorInfo.rgbString;
	pColorInfo->rgbCursorBack=pobj_Theme->TextColorInfo.rgbCursorBack;
	pColorInfo->rgbBackground=pobj_Theme->TextColorInfo.rgbBackground;

	//ANeBue[}ɃZbg
	lstrcpy(pobj_nv->szActiveTheme,pobj_Theme->m_name);

	//e[}ˑ̕`惊\[X擾
	pobj_DBTheme->unlock();
	pobj_DBTheme->lock();

	if(bRedraw){
		//ĕ`
		extern MDIINFO MdiInfo[MAX_WNDNUM];
		int i;
		for(i=0;i<MAX_WNDNUM;i++){
			if(MdiInfo[i].hwnd){
				if(IS_DOCUMENT_TEXT(MdiInfo[i].DocType)){
					SetTextEditWordColor(i);
					InvalidateRect(MdiInfo[i].pMdiTextEdit->hEdit,NULL,0);
				}
			}
		}
	}
}

BOOL SetupProjectEditor(void){
	extern HINSTANCE hInst;
	int i;
	char str[MAX_PATH],temporary[MAX_PATH];


	//\[XpDLL}bsO
#if defined(JPN)
	//{ꃊ\[X
	sprintf(temporary,"%sSubOperation\\res.dll",pj_editor_Dir);
#else
	//pꃊ\[X
	sprintf(temporary,"%sSubOperation\\res_e.dll",pj_editor_Dir);
#endif
	hResInst=LoadLibrary(temporary);

	//ACR\[XDLL}bsO
	sprintf(temporary,"%sSubOperation\\icon_res.dll",pj_editor_Dir);
	hIconResInst=LoadLibrary(temporary);

	//LuxCtrl.dll}bsO
	sprintf(temporary,"%sSubOperation\\LuxCtrl.dll",pj_editor_Dir);
	hLib_LuxCtrl=LoadLibrary(temporary);
	if(!hLib_LuxCtrl){
		MessageBox(0,"LuxCtrl.dll̓ǂݍ݂Ɏs܂B",APPLICATION_NAME,MB_OK|MB_ICONEXCLAMATION);
		return 0;
	}
	LuxToolbar_CreateInstance=
		(PROC_LuxToolbar_CreateInstance)GetProcAddress(hLib_LuxCtrl,"LuxToolbar_CreateInstance");


	//W[fBNg擾
	GetModuleFileName(hInst,temporary,MAX_PATH);
	_splitpath(temporary,pj_editor_Dir,str,NULL,NULL);
	lstrcat(pj_editor_Dir,str);

	//q[vIuWFNg쐬
	extern HANDLE hHeap;
	hHeap=HeapCreate(HEAP_GENERATE_EXCEPTIONS,0,0);


	//obNAbvp̃fBNg𐶐
	CreateBackupDir();


	//COM
	CoInitialize(0);

	//XN[TCY擾
	ScreenX=GetSystemMetrics(SM_CXSCREEN);
	ScreenY=GetSystemMetrics(SM_CYSCREEN);

	//RpCZbgiftHgWin32j
	extern char *lpszCompilerName;
	lpszCompilerName=WIN32_COMPILER_NAME;

	//s̃f[^擾
	pobj_nv=new CNonVolatile;
	pobj_nv->load();


	//At@uhpAPI擾
	extern FWINLAYER pSetLayeredWindowAttributes;
	extern HINSTANCE hUser32Lib;
	hUser32Lib=LoadLibrary("user32.dll");
	pSetLayeredWindowAttributes=(FWINLAYER)GetProcAddress(hUser32Lib,"pSetLayeredWindowAttributes");




	/////////////////////
	// tHg`
	/////////////////////

	//p[^ qg tHg
	extern METHODCHECKINFO MethodCheckInfo;
	MethodCheckInfo.hFont=CreateFontIndirect(&MethodCheckInfo.LogFont);
	i=MethodCheckInfo.LogFont.lfWeight;
	MethodCheckInfo.LogFont.lfWeight=FW_BOLD;
	MethodCheckInfo.hBoldFont=CreateFontIndirect(&MethodCheckInfo.LogFont);
	MethodCheckInfo.LogFont.lfWeight=i;

	//Xe[^Xo[ tHg
	LOGFONT LogFont;
	extern HFONT hStatusFont;
	LogFont.lfHeight=-12;
	LogFont.lfWidth=0;
	LogFont.lfEscapement=0;
	LogFont.lfOrientation=0;
	LogFont.lfWeight=FW_REGULAR;
	LogFont.lfItalic=NULL;
	LogFont.lfUnderline=NULL;
	LogFont.lfStrikeOut=NULL;
	LogFont.lfCharSet=SHIFTJIS_CHARSET;
	LogFont.lfOutPrecision=OUT_STRING_PRECIS;
	LogFont.lfClipPrecision=CLIP_STROKE_PRECIS;
	LogFont.lfQuality=DRAFT_QUALITY;
	LogFont.lfPitchAndFamily=VARIABLE_PITCH;
	sprintf(LogFont.lfFaceName,"lr oSVbN");
	hStatusFont=CreateFontIndirect(&LogFont);

	//nCp[N tHg
	extern HFONT hHyperLinkFont;
	LogFont.lfHeight=-12;
	LogFont.lfWidth=0;
	LogFont.lfEscapement=0;
	LogFont.lfOrientation=0;
	LogFont.lfWeight=FW_REGULAR;
	LogFont.lfItalic=NULL;
	LogFont.lfUnderline=TRUE;
	LogFont.lfStrikeOut=NULL;
	LogFont.lfCharSet=SHIFTJIS_CHARSET;
	LogFont.lfOutPrecision=OUT_STRING_PRECIS;
	LogFont.lfClipPrecision=CLIP_STROKE_PRECIS;
	LogFont.lfQuality=DRAFT_QUALITY;
	LogFont.lfPitchAndFamily=VARIABLE_PITCH;
	sprintf(LogFont.lfFaceName,"lr oSVbN");
	hHyperLinkFont=CreateFontIndirect(&LogFont);

	//[[ tHg
	extern HFONT hRulerFont;
	LogFont.lfHeight=-10;
	LogFont.lfWidth=0;
	LogFont.lfEscapement=0;
	LogFont.lfOrientation=0;
	LogFont.lfWeight=FW_REGULAR;
	LogFont.lfItalic=NULL;
	LogFont.lfUnderline=0;
	LogFont.lfStrikeOut=NULL;
	LogFont.lfCharSet=SHIFTJIS_CHARSET;
	LogFont.lfOutPrecision=OUT_STRING_PRECIS;
	LogFont.lfClipPrecision=CLIP_STROKE_PRECIS;
	LogFont.lfQuality=DRAFT_QUALITY;
	LogFont.lfPitchAndFamily=VARIABLE_PITCH;
	sprintf(LogFont.lfFaceName,"lr SVbN");
	hRulerFont=CreateFontIndirect(&LogFont);

	//sԍ̕`p
	extern HFONT hFont_LineNumber;
	LogFont.lfHeight=-11;
	LogFont.lfWidth=0;
	LogFont.lfEscapement=0;
	LogFont.lfOrientation=0;
	LogFont.lfWeight=FW_BOLD;
	LogFont.lfItalic=NULL;
	LogFont.lfUnderline=NULL;
	LogFont.lfStrikeOut=NULL;
	LogFont.lfCharSet=ANSI_CHARSET;
	LogFont.lfOutPrecision=OUT_STRING_PRECIS;
	LogFont.lfClipPrecision=CLIP_STROKE_PRECIS;
	LogFont.lfQuality=DRAFT_QUALITY;
	LogFont.lfPitchAndFamily=VARIABLE_PITCH;
	sprintf(LogFont.lfFaceName,"Courier New");
	hFont_LineNumber=CreateFontIndirect(&LogFont);

	//j[tHg
    NONCLIENTMETRICS NCMetrics;
    NCMetrics.cbSize = sizeof( NONCLIENTMETRICS );
    SystemParametersInfo( SPI_GETNONCLIENTMETRICS, sizeof( NONCLIENTMETRICS ), &NCMetrics, 0 );
	hMenuFont=CreateFontIndirect(&NCMetrics.lfMenuFont);



	//wiuV
	extern HBRUSH h3DFaceBackBrush;
	h3DFaceBackBrush=CreateSolidBrush(GetSysColor(COLOR_3DFACE));

	//ACR
	extern HICON hOwnerIcon,hBasicProgramIcon,hTextDocumentIcon,hWindowDocumentIcon;
	hOwnerIcon=(HICON)LoadImage(hInst,MAKEINTRESOURCE(IDI_MAIN),IMAGE_ICON,16,16,LR_DEFAULTCOLOR);
	hBasicProgramIcon=(HICON)LoadImage(hResInst,MAKEINTRESOURCE(IDI_BASICPROGRAM),IMAGE_ICON,16,16,LR_DEFAULTCOLOR);
	hTextDocumentIcon=(HICON)LoadImage(hResInst,MAKEINTRESOURCE(IDI_TEXTDOCUMENT),IMAGE_ICON,16,16,LR_DEFAULTCOLOR);
	hWindowDocumentIcon=(HICON)LoadImage(hResInst,MAKEINTRESOURCE(IDI_WINDOW),IMAGE_ICON,16,16,LR_DEFAULTCOLOR);




	//Cj[
	pobj_MainMenu=new CMenuEx(LoadMenu(hResInst,MAKEINTRESOURCE(IDR_MAINMENU)));

	pobj_MainMenu->InitOwnerDraw(1);			//I[i[`̏

	CSubMenuEx *pobj_FileMenu;
	pobj_FileMenu=pobj_MainMenu->ppobj_MenuItemData[0]->pobj_SubMenu;

	//
	extern HMENU hFirstMainMenu;
	hFirstMainMenu=0;

	//uŋߎgt@CvTuj[擾iƓɂK̃j[wj
	for(i=0;i<pobj_FileMenu->iMenuItemNum;i++){
		if(pobj_FileMenu->ppobj_MenuItemData[i]->str){
			if(lstrcmp(pobj_FileMenu->ppobj_MenuItemData[i]->str,"FileHistory")==0){
				pobj_FileMenu->RenameMenuItem(i,"ŋߎgt@C(&F)");

				extern CSubMenuEx *pobj_FileHistoryMenu;
				pobj_FileHistoryMenu=pobj_FileMenu->ppobj_MenuItemData[i]->pobj_SubMenu;
			}

#ifndef THETEXT
			//uŋߎgvWFNgvTuj[擾iƓɂK̃j[wj
			//ProjectEditor̂
			if(lstrcmp(pobj_FileMenu->ppobj_MenuItemData[i]->str,"ProjectHistory")==0){
				pobj_FileMenu->RenameMenuItem(i,"ŋߎgvWFNg(&J)");

				extern CSubMenuEx *pobj_ProjectHistoryMenu;
				pobj_ProjectHistoryMenu=pobj_FileMenu->ppobj_MenuItemData[i]->pobj_SubMenu;
			}
#endif
		}
	}

#define ICONSET(itemID,iconID) pobj_MainMenu->SetIcon(itemID,(HICON)LoadImage(hIconResInst,MAKEINTRESOURCE(iconID),IMAGE_ICON,16,16,0));
	//j[ACRZbg

	//t@C
	ICONSET(IDM_NEW,IDI_NEW);
	ICONSET(IDM_OPEN,IDI_OPEN);
	ICONSET(IDM_SAVE,IDI_SAVE);
	ICONSET(IDM_ALLSAVE,IDI_ALLSAVE);
	ICONSET(IDM_PREVIEW,IDI_PREVIEW);
	ICONSET(IDM_PRINTOUT,IDI_PRINT);

	//ҏW
	ICONSET(IDM_CUT,IDI_CUT);
	ICONSET(IDM_COPY,IDI_COPY);
	ICONSET(IDM_PASTE,IDI_PASTE);
	ICONSET(IDM_UNDO,IDI_UNDO);
	ICONSET(IDM_REDO,IDI_REDO);
	ICONSET(IDM_FIND,IDI_FIND);

	//\
	ICONSET(IDM_SET,IDI_OPTION);

	//ϊ
	ICONSET(IDM_CONV_ALPHA_SMALL,IDI_CONV_ALPHA_SMALL);
	ICONSET(IDM_CONV_ALPHA_BIG,IDI_CONV_ALPHA_BIG);
	ICONSET(IDM_CONV_HALF,IDI_CONV_HALF);
	ICONSET(IDM_CONV_MULTI,IDI_CONV_MULTI);
	ICONSET(IDM_CONV_KATAKANA,IDI_CONV_KATAKANA);
	ICONSET(IDM_CONV_HIRAGANA,IDI_CONV_HIRAGANA);

	//wv
	ICONSET(IDM_TOPIC,IDI_HELP);

#ifdef THETEXT
	//TheText݂̂̋@\
	ICONSET(IDM_STRING_COUNT,IDI_STRINGCOUNT);
#else
	//ProjectEditor݂̂̋@\

	//[X
	ICONSET(IDM_RELEASECOMPILE,IDI_RELEASECOMPILE);
	ICONSET(IDM_RELEASERUN,IDI_RELEASERUN);

	//fobO
	ICONSET(IDM_ATTACH,IDI_ATTACH);
	ICONSET(IDM_DEBUGCOMPILE,IDI_DEBUGCOMPILE);
	ICONSET(IDM_DEBUG,IDI_DEBUGRUN);
	ICONSET(IDM_BREAKPOINT,IDI_BREAKPOINT);
	ICONSET(IDM_STEP_IN,IDI_STEPIN);
	ICONSET(IDM_STEP_OVER,IDI_STEPOVER);
	ICONSET(IDM_STEP_CURSOR,IDI_STEPTOCURSOR);
	ICONSET(IDM_DEBUG_PAUSE,IDI_DEBUGPAUSE);
	ICONSET(IDM_DEBUG_STOP,IDI_DEBUGSTOP);

	//R~jeB
	ICONSET(IDM_COMMUNITY,IDI_COMMUNITY_MAIN);
	ICONSET(IDM_COMMU_SEARCH,IDI_COMMUNITY_FIND);
	ICONSET(IDM_COMMU_PM,IDI_COMMUNITY_PRIVATEMSG);
	ICONSET(ID_COMMU_FORUM1,IDI_COMMUNITY_FORUM);
	ICONSET(ID_COMMU_FORUM2,IDI_COMMUNITY_FORUM);
	ICONSET(ID_COMMU_FORUM3,IDI_COMMUNITY_FORUM);
	ICONSET(ID_COMMU_FORUM4,IDI_COMMUNITY_FORUM);
	ICONSET(ID_COMMU_FORUM5,IDI_COMMUNITY_FORUM);
	ICONSET(ID_COMMU_FORUM6,IDI_COMMUNITY_FORUM_SECRET);
	ICONSET(ID_COMMU_FORUM7,IDI_COMMUNITY_FORUM);
	ICONSET(ID_COMMU_FORUM8,IDI_COMMUNITY_FORUM);
#endif

#undef ICONSET




	extern HMENU hEditMenuBase,hEditMenu;
	hEditMenuBase=LoadMenu(hResInst,MAKEINTRESOURCE(IDR_EDITMENU));
	hEditMenu=GetSubMenu(hEditMenuBase,0);

	extern HMENU hRebarMenuBase,hRebarMenu;
	hRebarMenuBase=LoadMenu(hResInst,MAKEINTRESOURCE(IDR_REBARMENU));
	hRebarMenu=GetSubMenu(hRebarMenuBase,0);

	extern HMENU hTabMenuBase,hTabMenu,hTabColorMenu;
	hTabMenuBase=LoadMenu(hResInst,MAKEINTRESOURCE(IDR_TABMENU));
	hTabMenu=GetSubMenu(hTabMenuBase,0);
	hTabColorMenu=GetSubMenu(hTabMenu,0);

	extern HMENU hFileTreeMenuBase;
	hFileTreeMenuBase=LoadMenu(hResInst,MAKEINTRESOURCE(IDR_PROJECTVIEW_FILETREEMENU));

	extern HMENU hProcedureTreeMenuBase;
	hProcedureTreeMenuBase=LoadMenu(hResInst,MAKEINTRESOURCE(IDR_PROJECTVIEW_PROCEDURETREEMENU));

	extern HMENU hMaterialTreeMenuBase;
	hMaterialTreeMenuBase=LoadMenu(hResInst,MAKEINTRESOURCE(IDR_PROJECTVIEW_MATERIALTREEMENU));

	extern HMENU hRadMenuBase;
	hRadMenuBase=LoadMenu(hResInst,MAKEINTRESOURCE(IDR_RADCONTEXTMENU));

	//Nbv{[h̃f[^`iRADpjVKo^
	extern DWORD dwRadClipboardID;
	dwRadClipboardID=RegisterClipboardFormat("ProjectEditor-RAD");

	//256F̕Wpbgǂݍ
	extern RGBQUAD DefaultColorTable256[256];
	HANDLE hFile;
	DWORD dw;
	sprintf(temporary,"%sSubOperation\\8bit.plt",pj_editor_Dir);
	hFile=CreateFile(temporary,GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if(hFile==INVALID_HANDLE_VALUE){
		//"\"%s\" t@C̓ǂݍ݂Ɏs܂B"
		sprintf(str,STRING_ERROR_CANT_FILEOPEN,temporary);
		MessageBox(NULL,str,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);
		return 0;
	}
	ReadFile(hFile,DefaultColorTable256,sizeof(RGBQUAD)*256,&dw,NULL);
	CloseHandle(hFile);



	//fUCe[}IuWFNg𐶐
	pobj_DBTheme=new CDBTheme();


	/////////////////////////
	// J[fUCݒ
	CTheme *pobj_Theme;
	pobj_Theme=pobj_DBTheme->GetActiveTheme();
	if(!pobj_Theme) pobj_Theme=pobj_DBTheme->ppobj_Theme[0];

	SetTextEditColorDesign(&tci,pobj_Theme,0);


#ifndef THETEXT
	/////////////////////////////////////////////////////
	// ProjectEditor̂
	/////////////////////////////////////////////////////


	//NXr[ǗIuWFNg𐶐
	pobj_ClassTreeView=new CClassTreeView();


	/////////////////////////
	// basic.sbp̓e擾
	/////////////////////////

	extern char *pHeaderBuf;
	sprintf(temporary,"%sbasic.sbp",pobj_nv->szIncludeDir);
	GetFullPath( temporary, pj_editor_Dir );
	pHeaderBuf=ReadBuffer(temporary);

	if( !pHeaderBuf ){
		pHeaderBuf=(char *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,1);
	}

	//t@CCN[h
	pHeaderBuf=IncludeFiles(pHeaderBuf);


	//fobKǗIuWFNg𐶐
	pobj_Debugger=new CDebugger();
#endif


	//u[N|CgǗIuWFNg𐶐
	extern CDBBreakPoint *pobj_DBBreakPoint;
	pobj_DBBreakPoint=new CDBBreakPoint();


	return 1;
}
void EndProjectEditor(void){

#ifndef THETEXT
	/////////////////////////////////////////////////////
	// ProjectEditor̂
	/////////////////////////////////////////////////////


	//NXr[ǗIuWFNgj
	delete pobj_ClassTreeView;
	pobj_ClassTreeView=0;

	//basic.sbp̃\[XR[hobt@
	extern char *pHeaderBuf;
	HeapDefaultFree(pHeaderBuf);

	//fobKǗIuWFNgj
	delete pobj_Debugger;
#endif

	//u[N|CgǗIuWFNgj
	extern CDBBreakPoint *pobj_DBBreakPoint;
	delete pobj_DBBreakPoint;

	//fUCe[}IuWFNgj
	delete pobj_DBTheme;

	//s̃f[^ۑ
	pobj_nv->save();
	delete pobj_nv;
	pobj_nv=0;

	//Cj[IuWFNgj
	delete pobj_MainMenu;
	pobj_MainMenu=0;

	extern HFONT hStatusFont;
	DeleteObject(hStatusFont);
	extern HFONT hHyperLinkFont;
	DeleteObject(hHyperLinkFont);
	extern HFONT hRulerFont;
	DeleteObject(hRulerFont);
	extern HFONT hFont_LineNumber;
	DeleteObject(hFont_LineNumber);
	extern METHODCHECKINFO MethodCheckInfo;
	DeleteObject(MethodCheckInfo.hFont);
	DeleteObject(MethodCheckInfo.hBoldFont);
	extern HICON hOwnerIcon,hBasicProgramIcon,hTextDocumentIcon,hWindowDocumentIcon;
	DestroyIcon(hOwnerIcon);
	DestroyIcon(hBasicProgramIcon);
	DestroyIcon(hTextDocumentIcon);
	DestroyIcon(hWindowDocumentIcon);
	extern HMENU hEditMenuBase,hRebarMenuBase,hTabMenuBase;
	DestroyMenu(hEditMenuBase);
	DestroyMenu(hRebarMenuBase);
	DestroyMenu(hTabMenuBase);
	extern HMENU hFileTreeMenuBase;
	DestroyMenu(hFileTreeMenuBase);
	extern HMENU hProcedureTreeMenuBase;
	DestroyMenu(hProcedureTreeMenuBase);
	extern HMENU hMaterialTreeMenuBase;
	DestroyMenu(hMaterialTreeMenuBase);
	extern HMENU hRadMenuBase;
	DestroyMenu(hRadMenuBase);

	//wiuV
	extern HBRUSH h3DFaceBackBrush;
	DeleteObject(h3DFaceBackBrush);

	//X^_[hc[o[j
	if(pobj_StandardToolbar){
		pobj_StandardToolbar->Release();
		pobj_StandardToolbar=0;
	}

	//rhc[o[j
	if(pobj_ReleaseToolbar){
		pobj_ReleaseToolbar->Release();
		pobj_ReleaseToolbar=0;
	}

	//fobKpc[o[j
	if(pobj_DebuggerToolbar){
		pobj_DebuggerToolbar->Release();
		pobj_DebuggerToolbar=0;
	}

	//q[vIuWFNg
	extern HANDLE hHeap;
	HeapDestroy(hHeap);

	//DLL
	FreeLibrary(hResInst);
	FreeLibrary(hIconResInst);
	FreeLibrary(hLib_LuxCtrl);

	//At@uhpAPI
	extern HINSTANCE hUser32Lib;
	FreeLibrary(hUser32Lib);




	//////////////////////////////////////
	// obNAbvpt@C폜
	//////////////////////////////////////
	extern char szBackupDirPath[MAX_PATH];
	RemoveDirectoryStrong(szBackupDirPath);

}

//eEBhE
void SetupWindow(HWND hwnd){
	extern HINSTANCE hInst;
	extern HMENU hFirstMainMenu;
	RECT rect;
	CLIENTCREATESTRUCT ccs;

	INITCOMMONCONTROLSEX InitCommCtrl;
	InitCommCtrl.dwSize=sizeof(INITCOMMONCONTROLSEX);
	InitCommCtrl.dwICC=ICC_COOL_CLASSES|ICC_PAGESCROLLER_CLASS|ICC_WIN95_CLASSES|ICC_TAB_CLASSES;
	InitCommonControlsEx(&InitCommCtrl);

	//^uEBhE
	pobj_MainTab=new CMainTab(hwnd);

	//MDI̐eEBhEiNCAgEBhEj쐬
	ccs.hWindowMenu=hFirstMainMenu;
	ccs.idFirstChild=ID_FIRSTCHILD;
	GetClientRect(hwnd,&rect);
	hClient=CreateWindowEx(WS_EX_CLIENTEDGE,"MDICLIENT",NULL,
		WS_CHILD|WS_CLIPCHILDREN|WS_CLIPSIBLINGS|WS_VISIBLE,
		0,0,0,0,
		hwnd,(HMENU)1,hInst,(LPSTR)&ccs);

	//o[IuWFNg𐶐
	pobj_Rebar=new CMainRebar(hwnd);

	//Xe[^Xo[
	extern HWND hStatusBar;
	extern HFONT hStatusFont;
	hStatusBar=CreateStatusWindow(
		WS_VISIBLE|WS_CHILD|WS_CLIPSIBLINGS|SBARS_SIZEGRIP|CCS_BOTTOM,
		NULL,hwnd,NULL);
	SendMessage(hStatusBar,WM_SETFONT,(long)hStatusFont,0);

	//vWFNg r[
	extern HWND hProjectView;
	extern HWND hProjectView_ToolWindow;
	RECT *prc;
	prc=&pobj_nv->rectProjectView;
	hProjectView_ToolWindow=CreateWindowEx(WS_EX_TOOLWINDOW,"ProjectView_ToolWindow","ProjectView",
		WS_POPUP|WS_CAPTION|WS_SYSMENU|WS_THICKFRAME|WS_CLIPCHILDREN,
		prc->left,prc->top,prc->right-prc->left,prc->bottom-prc->top,
		hwnd,0,hInst,0);
	hProjectView=CreateWindowEx(WS_EX_STATICEDGE,"ProjectView","ProjectView",
		WS_CHILD|WS_CLIPCHILDREN,
		0,0,0,0,
		hwnd,0,hInst,0);
	if(pobj_nv->bClipProjectView==0){
		SetWindowLong(hProjectView,GWL_EXSTYLE,0);
		SetParent(hProjectView,hProjectView_ToolWindow);
		ResizeProjectView_ToolWindow();
	}

	//j[Ԃݒ
	ResetState_DocMenu();


	//SideWeb𐶐
	pobj_SideWeb=new CSideWeb(hwnd);
}

//sR}h
BOOL SetRunning(HWND hChild){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern LPSTR DefFileFilter;
	int WndNum;
	char temporary[MAX_PATH],temp2[MAX_PATH];
	HANDLE hFind;
	WIN32_FIND_DATA wfd;

	extern char *lpszCompilerName;
	sprintf(temporary,"%s%s",pj_editor_Dir,lpszCompilerName);
	hFind=FindFirstFile(temporary,&wfd);
	if(hFind==INVALID_HANDLE_VALUE){
		//"BasicCompiler.exe ܂"
		MessageBox(hOwner,STRING_ERROR_NOBASICCOMPILER,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);
		return FALSE;
	}
	FindClose(hFind);

	WndNum=GetWndNum(hChild);
	if(IS_DOCUMENT_TEXT(MdiInfo[WndNum].DocType)){
		if(MdiInfo[WndNum].path[0]=='\0'){
			//"ۑ̃t@Cw肵Ă"
			if(!GetFilePathDialog(hOwner,temp2,DefFileFilter,STRING_FILESAVETITLE_DEFAULT,0)) return FALSE;

			if(!SaveDocument(hChild,temp2)) return 0;
		}
		else{
			if( MdiInfo[WndNum].pMdiTextEdit->IsModified() ){
				if(!SaveDocument(hChild,NULL)) return 0;
			}
			else{
				if(hFind=FindFirstFile(MdiInfo[WndNum].path,&wfd)){
					if(hFind==INVALID_HANDLE_VALUE){
						if(!SaveDocument(hChild,NULL)) return 0;
					}
					else FindClose(hFind);
				}
			}
		}
	}
	return 1;
}

BOOL IsNeedCompile(char *FileName,BOOL bDebug){
	char temporary[MAX_PATH],temp2[MAX_PATH],temp3[MAX_PATH];
	HANDLE hFind,hFile;
	WIN32_FIND_DATA wfd;
	FILETIME SourceTime,ExeTime;

	_splitpath(FileName,temporary,temp2,temp3,NULL);
	lstrcat(temporary,temp2);
	lstrcat(temporary,temp3);
	if(bDebug) lstrcat(temporary,"_debug.exe");
	else lstrcat(temporary,".exe");

	hFind=FindFirstFile(temporary,&wfd);
	if(hFind==INVALID_HANDLE_VALUE) return 1;
	FindClose(hFind);

	hFile=CreateFile(FileName,GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	GetFileTime(hFile,NULL,NULL,&SourceTime);
	CloseHandle(hFile);

	hFile=CreateFile(temporary,GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	GetFileTime(hFile,NULL,NULL,&ExeTime);
	CloseHandle(hFile);

	if(SourceTime.dwHighDateTime<ExeTime.dwHighDateTime) return 0;
	else if(SourceTime.dwHighDateTime==ExeTime.dwHighDateTime&&
		SourceTime.dwLowDateTime<=ExeTime.dwLowDateTime) return 0;
	return 1;
}

string GetLastErrorString(){
	char *lpMsgBuf;

	FormatMessage( 
		FORMAT_MESSAGE_ALLOCATE_BUFFER | 
		FORMAT_MESSAGE_FROM_SYSTEM | 
		FORMAT_MESSAGE_IGNORE_INSERTS,
		NULL,
		GetLastError(),
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // ftHg
		(LPTSTR) &lpMsgBuf,
		0,
		NULL 
	);

	string result = lpMsgBuf;

	LocalFree( lpMsgBuf );

	return result;
}
