#include "common.h"

#ifdef _AMD64_
#include "../BasicCompiler64/opcode.h"
#else
#include "../BasicCompiler32/opcode.h"
#endif

CDBClass *pobj_DBClass;

CClass *pobj_CompilingClass;
CClass *pobj_StringClass;

CMember *pCompilingMethod;



CMember::CMember( CClass *pobj_c, DWORD access, bool isConst, bool isRef, char *buffer, int nowLine ){
	extern int cp;

	//\
	char VarName[VN_SIZE];
	char init_buf[VN_SIZE];
	char constract_parameter[VN_SIZE];
	GetDimentionFormat(buffer,VarName,SubScripts,*this,init_buf,constract_parameter);

	//d`FbN
	if(pobj_c->DupliCheckAll(VarName)){
		SetError(15,VarName,cp);
	}

	//o
	name=(char *)HeapAlloc(hHeap,0,lstrlen(VarName)+1);
	lstrcpy(name,VarName);

	//ANZX
	dwAccess=access;

	//萔ǂ
	this->isConst = isConst;

	//f[^
	InitBuf=(char *)HeapAlloc(hHeap,0,lstrlen(init_buf)+1);
	lstrcpy(InitBuf,init_buf);

	//RXgN^p̃p[^
	ConstractParameter=(char *)HeapAlloc(hHeap,0,lstrlen(constract_parameter)+1);
	lstrcpy(ConstractParameter,constract_parameter);

	//\[XR[ḧʒu
	source_code_address=nowLine;
}
CMember::CMember(CMember &member):
	Type( member )
{

	//name
	name=(char *)HeapAlloc(hHeap,0,lstrlen(member.name)+1);
	lstrcpy(name,member.name);

	//萔ǂ
	isConst = member.isConst;

	//SubScripts
	memcpy(SubScripts,member.SubScripts,MAX_ARRAYDIM*sizeof(int));

	//\[XR[ḧʒu
	source_code_address=member.source_code_address;
}
CMember::CMember(){
	memset(this,0,sizeof(CMember));
}
CMember::~CMember(){
	HeapDefaultFree(name);
	if(InitBuf) HeapDefaultFree(InitBuf);
	if(ConstractParameter) HeapDefaultFree(ConstractParameter);
}

bool CMember::IsConst(){
	return isConst;
}

void CMember::InitStaticMember(void){
	//ÓIoO[öɍ쐬

	//Ce[^Zbg
	extern CDBClass *pobj_DBClass;
	pobj_DBClass->Iterator_Reset();

	int back_cp=cp;

	while(pobj_DBClass->Iterator_HasNext()){
		CClass &objClass = *pobj_DBClass->Iterator_GetNext();

		// OԂZbg
		Smoothie::Lexical::liveingNamespaceScopes = objClass.GetNamespaceScopes();

		int i=0;
		foreach( CMember *member, objClass.staticMembers ){
			char temporary[VN_SIZE];
			sprintf(temporary,"%s.%s",objClass.name,member->name);
			dim(
				temporary,
				member->SubScripts,
				*member,
				member->InitBuf,
				member->ConstractParameter,
				0);

			//lCeBuR[hobt@̍Ċm
			ReallocNativeCodeBuffer();

			i++;
		}
	}

	Smoothie::Lexical::liveingNamespaceScopes.clear();

	cp=back_cp;
}



//Rs[RXgN^
CMethod::CMethod(CMethod *pMethod)
	: pUserProc( pMethod->pUserProc )
	, dwAccess( pMethod->dwAccess )
	, bAbstract( pMethod->bAbstract )
	, bVirtual( pMethod->bVirtual )
	, isConst( pMethod->isConst )
	, isStatic( pMethod->isStatic )
{
}

CMethod::CMethod( UserProc *pUserProc, DWORD dwAccess, BOOL bAbstract, BOOL bVirtual, bool isConst, bool isStatic )
	: pUserProc( pUserProc )
	, dwAccess( dwAccess )
	, bAbstract( bAbstract )
	, bVirtual( bVirtual )
	, isConst( isConst )
	, isStatic( isStatic )
	, pobj_InheritsClass( NULL )
{
}
CMethod::~CMethod(){
}



CClass::CClass( const NamespaceScopes &namespaceScopes, const char *name ):
	namespaceScopes( namespaceScopes ),
	ConstructorMemberSubIndex( 0 ),
	DestructorMemberSubIndex( 0 ),
	classType( Class ),
	isUsing( false ),
	pobj_InheritsClass( NULL ),
	ppobj_Member( NULL ),
	iMemberNum( 0 ),
	vtbl_num( 0 ),
	iAlign( 0 ),
	vtbl_offset( -1 ),
	isCompilingConstructor( false ),
	isCompilingDestructor( false ),
	pobj_NextClass( NULL )
{
	this->name=(char *)HeapAlloc(hHeap,0,lstrlen(name)+1);
	lstrcpy(this->name,name);
}
CClass::~CClass(){
	int i;

	//NX
	HeapDefaultFree(name);

	if(ppobj_Member){
		//o
		for(i=0;i<iMemberNum;i++){
			delete ppobj_Member[i];
		}
		HeapDefaultFree(ppobj_Member);
		ppobj_Member=0;
	}

	//ÓIo
	foreach( CMember *member, staticMembers ){
		delete member;
	}

	//\bh
	foreach( CMethod *method, methods ){
		delete method;
	}

	//ÓI\bh
	foreach( CMethod *method, staticMethods ){
		delete method;
	}
}

bool CClass::IsEqualSymbol( const NamespaceScopes &namespaceScopes, const string &name ) const
{
	if( GetName() != name ){
		return false;
	}

	return NamespaceScopes::IsSameArea( GetNamespaceScopes(), namespaceScopes );
}
bool CClass::IsEqualSymbol( const CClass &objClass ) const
{
	return IsEqualSymbol( objClass.GetNamespaceScopes(), objClass.GetName() );
}
bool CClass::IsEqualSymbol( const string &fullName ) const
{
	char AreaName[VN_SIZE] = "";		//IuWFNgϐ
	char NestName[VN_SIZE] = "";		//qo
	bool isNest = SplitMemberName( fullName.c_str(), AreaName, NestName );

	return IsEqualSymbol( NamespaceScopes( AreaName ), NestName );
}

bool CClass::IsUsing() const
{
	return isUsing;
}
void CClass::Using(){
	isUsing = true;
}

bool CClass::IsClass() const
{
	return classType == CClass::Class;
}
bool CClass::IsInterface() const
{
	return classType == CClass::Interface;
}
bool CClass::IsEnum() const
{
	return classType == CClass::Enum;
}
bool CClass::IsDelegate() const
{
	return classType == CClass::Delegate;
}
bool CClass::IsStructure() const
{
	return classType == CClass::Structure;
}

bool CClass::Inherits( CClass &inheritsClass, int nowLine ){

	//[vpłȂ`FbN
	if(pobj_LoopRefCheck->check(inheritsClass)){
		SetError(123,inheritsClass.name,nowLine);
		return false;
	}

	if( inheritsClass.ppobj_Member == 0 ){
		//p悪ǂݎĂȂƂ
		pobj_LoopRefCheck->add(this->name);
		pobj_DBClass->GetClass_recur(inheritsClass.name);
		pobj_LoopRefCheck->del(this->name);
	}

	//oRs[
	ppobj_Member=(CMember **)HeapReAlloc(
		hHeap,
		0,
		ppobj_Member,
		( iMemberNum + inheritsClass.iMemberNum )*sizeof(CMember *));
	for(int i3=0;i3<inheritsClass.iMemberNum;i3++){
		ppobj_Member[iMemberNum]=new CMember( *inheritsClass.ppobj_Member[i3] );

		//dwAccess
		if(inheritsClass.ppobj_Member[i3]->dwAccess==ACCESS_PRIVATE)
			ppobj_Member[iMemberNum]->dwAccess=ACCESS_NON;
		else ppobj_Member[iMemberNum]->dwAccess=inheritsClass.ppobj_Member[i3]->dwAccess;

		iMemberNum++;
	}

	//\bhRs[
	foreach( CMethod *baseMethod, inheritsClass.methods ){
		CMethod *method = new CMethod( baseMethod );

		//dwAccess
		if(baseMethod->dwAccess==ACCESS_PRIVATE)
			method->dwAccess=ACCESS_NON;
		else method->dwAccess=baseMethod->dwAccess;

		//pobj_Inherits
		// pClassIndexZbgiqplj
		if(baseMethod->pobj_InheritsClass==0)
			method->pobj_InheritsClass=&inheritsClass;
		else
			method->pobj_InheritsClass=
				baseMethod->pobj_InheritsClass;

		methods.push_back( method );
	}

	//z֐̐
	vtbl_num += inheritsClass.vtbl_num;

	//p̃NXoƂĕێ
	pobj_InheritsClass = &inheritsClass;

	return true;
}
bool CClass::InheritsInterface( CClass &inheritsInterface, int nowLine ){

	//[vpłȂ`FbN
	if(pobj_LoopRefCheck->check(inheritsInterface)){
		SetError(123,inheritsInterface.name,nowLine);
		return false;
	}

	if( inheritsInterface.ppobj_Member == 0 ){
		//p悪ǂݎĂȂƂ
		pobj_LoopRefCheck->add(this->name);
		pobj_DBClass->GetClass_recur(inheritsInterface.name);
		pobj_LoopRefCheck->del(this->name);
	}

	//\bhRs[
	foreach( CMethod *baseMethod, inheritsInterface.methods ){
		CMethod *method = new CMethod( baseMethod );

		//dwAccess
		if(baseMethod->dwAccess==ACCESS_PRIVATE)
			method->dwAccess=ACCESS_NON;
		else method->dwAccess=baseMethod->dwAccess;

		//pobj_Inherits
		// pClassIndexZbgiqplj
		if(baseMethod->pobj_InheritsClass==0)
			method->pobj_InheritsClass=&inheritsInterface;
		else
			method->pobj_InheritsClass=
				baseMethod->pobj_InheritsClass;

		methods.push_back( method );
	}

	//z֐̐
	vtbl_num += inheritsInterface.vtbl_num;

	/*
	TODO: C^[tFCX̋@\
	//p̃NXoƂĕێ
	pobj_InheritsClass = &inheritsInterface;
	*/

	return true;
}
void CClass::AddMember( DWORD dwAccess, bool isConst, bool isRef, char *buffer ){
	ppobj_Member = (CMember **)HeapReAlloc( hHeap, 0, ppobj_Member, ( iMemberNum + 1 ) * sizeof(CMember *) );
	ppobj_Member[iMemberNum] = new CMember( this, dwAccess, isConst, isRef, buffer );
	iMemberNum++;
}
void CClass::AddStaticMember( DWORD dwAccess, bool isConst, bool isRef, char *buffer, int nowLine ){
	CMember *member = new CMember( this, dwAccess, isConst, isRef, buffer, nowLine );
	staticMembers.push_back( member );
}
void CClass::AddMethod( UserProc *pUserProc,DWORD dwAccess, bool isConst, BOOL bAbstract, BOOL bVirtual ){
	CMethod *method = new CMethod( pUserProc, dwAccess, bAbstract, bVirtual, isConst, false );

	methods.push_back( method );

	// vV[WIuWFNgƊ֘At
	pUserProc->SetMethod( method );
}
void CClass::AddStaticMethod(UserProc *pUserProc,DWORD dwAccess){
	CMethod *method = new CMethod( pUserProc, dwAccess, FALSE, FALSE, false, true );

	staticMethods.push_back( method );

	// vV[WIuWFNgƊ֘At
	pUserProc->SetMethod( method );
}
BOOL CClass::DupliCheckAll(const char *name){
	//d`FbN

	//o
	if(DupliCheckMember(name)) return 1;

	//\bh
	foreach( CMethod *method, methods ){
		if( lstrcmp( name, method->pUserProc->GetName().c_str() ) == 0 ){
			return 1;
		}
	}

	return 0;
}
BOOL CClass::DupliCheckMember(const char *name){
	//d`FbN

	//o
	for( int i=0;i<iMemberNum;i++){
		if(lstrcmp(name,ppobj_Member[i]->name)==0){
			return 1;
		}
	}

	//ÓIo
	foreach( CMember *member, staticMembers ){
		if( lstrcmp( name, member->name ) == 0 ){
			return 1;
		}
	}

	return 0;
}
CMethod *CClass::GetMethodInfo( UserProc *pUserProc ) const
{
	for( int i=(int)methods.size()-1; i>=0; i-- ){
		if( pUserProc == methods[i]->pUserProc ){
			return methods[i];
		}
	}
	return NULL;
}
CMethod *CClass::GetStaticMethodInfo( UserProc *pUserProc ) const
{
	for( int i=(int)staticMethods.size()-1; i>=0; i-- ){
		if( pUserProc == staticMethods[i]->pUserProc ) return staticMethods[i];
	}
	return NULL;
}
bool CClass::IsExistMethod( const char *name ) const
{
	foreach( CMethod *method, methods ){
		if( method->pUserProc->GetName() == name ) return true;
	}
	return false;
}
bool CClass::IsExistStaticMethod( const char *name ) const
{
	foreach( CMethod *method, staticMethods ){
		if( method->pUserProc->GetName() == name ) return true;
	}
	return false;
}

void CClass::EnumStaticMethod( const char *methodName, vector<UserProc *> &subs ) const
{
	foreach( CMethod *method, staticMethods ){
		if( method->pUserProc->GetName() == methodName ){
			subs.push_back( method->pUserProc );
		}
	}
}

void CClass::EnumMethod( const char *methodName, vector<UserProc *> &subs ) const
{
	//IuWFNg̃o֐̏ꍇ
	//I[o[Chꂽ֐ɃT[`Kv邽߁AobNT[`s
	for( int i=(int)methods.size()-1; i>=0; i-- ){
		if( methods[i]->pUserProc->GetName() == methodName ){
			subs.push_back( methods[i]->pUserProc );
		}
	}
}

void CClass::EnumMethod( const BYTE idOperatorCalc, vector<UserProc *> &subs ) const
{
	//IuWFNg̃o֐̏ꍇ
	//I[o[Chꂽ֐ɃT[`Kv邽߁AobNT[`s
	for( int i=(int)methods.size()-1; i>=0; i-- ){
		UserProc *pUserProc = methods[i]->pUserProc;
		const char *temp = pUserProc->GetName().c_str();
		if(temp[0]==1&&temp[1]==ESC_OPERATOR){
			if((BYTE)temp[2]==idOperatorCalc){
				subs.push_back( pUserProc );
			}
		}
	}
}

//ftHg RXgN^ \bh擾
CMethod *CClass::GetConstructorMethod() const
{
	if( ConstructorMemberSubIndex == -1 ) return NULL;
	return methods[ConstructorMemberSubIndex];
}

//fXgN^ \bh擾
CMethod *CClass::GetDestructorMethod() const
{
	if( DestructorMemberSubIndex == -1 ) return NULL;
	return methods[DestructorMemberSubIndex];
}

//TCY擾
int CClass::GetSize() const
{
	return GetMemberOffset( NULL, NULL );
}

//õItZbg擾
int CClass::GetMemberOffset( const char *memberName, int *pMemberNum ) const
{
	int i,i2,offset;

	//z֐݂ꍇ͊֐Xgւ̃|C^̃TCYǉ
	if(vtbl_num) offset=PTR_SIZE;
	else offset=0;

	int alignment;
	if(iAlign) alignment=iAlign;
	else alignment=1;

	int iMaxAlign=0;
	for(i=0;i<iMemberNum;i++){
		CMember *pMember = ppobj_Member[i];

		i2 = pMember->GetSize();

		//ACgZo
		int member_size;
		if( pMember->IsStruct() ){
			//oNX̃ACg擾
			member_size=pMember->GetClass().GetAlignment();
		}
		else{
			//oTCY擾
			member_size=i2;
		}
		if(iMaxAlign<member_size) iMaxAlign=member_size;

		//ACgl
		if(iAlign&&iAlign<member_size){
			if(offset%alignment) offset+=alignment-(offset%alignment);
		}
		else{
			if(alignment<member_size) alignment=member_size;

			if(member_size==0){
				//oȂNX
				//ȂiItZbǧvZȂj
			}
			else{
				if(offset%member_size) offset+=member_size-(offset%member_size);
			}
		}

		if(memberName){
			//ow肪ꍇ́AItZbgԂ
			if(lstrcmp(pMember->name,memberName)==0){
				if(pMemberNum) *pMemberNum=i;
				return offset;
			}
		}

		//zloTCY擾
		member_size=i2 * JumpSubScripts(pMember->SubScripts);

		//oTCYZ
		offset+= member_size;
	}

	if(iMaxAlign<alignment) alignment=iMaxAlign;

	//ACgl
	if(alignment){
		if(offset%alignment) offset+=alignment-(offset%alignment);
	}

	if(pMemberNum) *pMemberNum=i;
	return offset;
}

int CClass::GetAlignment() const
{
	int i;
	int alignment,member_size;

	if(vtbl_num) alignment=PTR_SIZE;
	else alignment=0;

	for(i=0;i<iMemberNum;i++){
		CMember *pMember = ppobj_Member[i];

		if(pMember->IsStruct()){
			//oNX̃ACg擾
			member_size=pMember->GetClass().GetAlignment();
		}
		else{
			//oTCY擾
			member_size = pMember->GetSize();
		}

		//ACgZbg
		if(alignment<member_size) alignment=member_size;
	}

	if(alignment==0) return 0;

	if(iAlign) alignment=iAlign;

	return alignment;
}



int CClass::GetFuncNumInVtbl( const UserProc *pUserProc ) const
{
	int n = 0;
	foreach( CMethod *method, methods ){
		if( method->pUserProc == pUserProc ) break;
		if( method->bVirtual ) n++;
	}
	return n;
}
LONG_PTR CClass::GetVtblGlobalOffset(void){

	//ɑ݂ꍇ͂Ԃ
	if(vtbl_offset!=-1) return vtbl_offset;



	//////////////////////////////////////
	// ݂ȂƂ͐Vɐ
	//////////////////////////////////////

	UserProc **ppsi;
	ppsi=(UserProc **)HeapAlloc(hHeap,0,vtbl_num*sizeof(GlobalProc *));

	//֐e[uɒlZbg
	int i2 = 0;
	foreach( CMethod *method, methods ){
		if(method->bVirtual){
			method->pUserProc->Using();

			if(method->bAbstract){
				extern int cp;
				SetError(300,NULL,cp);

				ppsi[i2]=0;
			}
			else{
				ppsi[i2]=method->pUserProc;
			}
			i2++;
		}
	}

	vtbl_offset=dataTable.AddBinary((void *)ppsi,vtbl_num*sizeof(LONG_PTR));

	for( int i=0; i < vtbl_num; i++ ){
		pobj_Reloc->AddSchedule_DataSection(vtbl_offset+i*sizeof(LONG_PTR));
	}

	HeapDefaultFree(ppsi);

	return vtbl_offset;
}
void CClass::ActionVtblSchedule(LONG_PTR ImageBase, LONG_PTR MemPos_CodeSection){
	if(vtbl_offset==-1) return;

	LONG_PTR *pVtbl;
	pVtbl=(LONG_PTR *)((char *)dataTable.GetPtr()+vtbl_offset);

	int i;
	for(i=0;i<vtbl_num;i++){
		GlobalProc *pUserProc;
		pUserProc=(GlobalProc *)pVtbl[i];
		if(!pUserProc) continue;
		pVtbl[i]=pUserProc->beginOpAddress+ImageBase+MemPos_CodeSection;
	}
}
bool CClass::IsAbstract() const
{
	// (abstract)̉z֐ꍇtrueԂ

	foreach( CMethod *method, methods ){
		if(method->bVirtual){
			if(method->bAbstract){
				return true;
			}
		}
	}

	return false;
}

// RXgN^̃RpCJn
void CClass::NotifyStartConstructorCompile(){
	isCompilingConstructor = true;
}

//RXgN^̃RpCI
void CClass::NotifyFinishConstructorCompile(){
	isCompilingConstructor = false;
}

//RXgN^RpCǂ𔻕
bool CClass::IsCompilingConstructor() const
{
	return isCompilingConstructor;
}

//fXgN^̃RpCJn
void CClass::NotifyStartDestructorCompile(){
	isCompilingDestructor = true;
}

//fXgN^̃RpCI
void CClass::NotifyFinishDestructorCompile(){
	isCompilingDestructor = false;
}

//fXgN^RpCǂ𔻕
bool CClass::IsCompilingDestructor() const
{
	return isCompilingDestructor;
}


//gƓNXǂmF
bool CClass::IsEquals( const CClass *pClass ) const
{
	if( this == pClass ) return true;
	return false;
}

//g̔hNXǂmF
bool CClass::IsSubClass( const CClass *pClass ) const
{
	pClass = pClass->pobj_InheritsClass;
	while( pClass ){
		if( this == pClass ) return true;
		pClass = pClass->pobj_InheritsClass;
	}
	return false;
}

//gƓ܂͔hNXǂmF
bool CClass::IsEqualsOrSubClass( const CClass *pClass ) const
{
	if( IsEquals( pClass ) ) return true;
	return IsSubClass( pClass );
}

// gƓ܂͔hNXANXǂmF
bool CClass::IsEqualsOrSubClassOrSuperClass( const CClass &objClass ) const
{
	if( IsEquals( &objClass ) ) return true;
	if( IsSubClass( &objClass ) ) return true;
	if( objClass.IsSubClass( this ) ) return true;
	return false;
}



int CDBClass::hash(const char *name) const{
	int key;

	for(key=0;*name!='\0';name++){
		key=((key<<8)+ *name )%MAX_CLASS_HASH;
	}

	return key;
}

void CDBClass::DestroyClass(CClass *pobj_c){
	if(pobj_c->pobj_NextClass){
		DestroyClass(pobj_c->pobj_NextClass);
	}

	delete pobj_c;
}

CDBClass::CDBClass():
	pStringClass( NULL ),
	pObjectClass( NULL ),
	pCompilingClass( NULL ),
	pCompilingMethod( NULL ),
	ppobj_IteClass( NULL ),
	iIteMaxNum( 0 ),
	iIteNextNum( 0 )
{
	memset( pobj_ClassHash, 0, MAX_CLASS_HASH * sizeof(CClass *) );
}
CDBClass::~CDBClass(){
	int i;
	for(i=0;i<MAX_CLASS_HASH;i++){
		if(pobj_ClassHash[i]) DestroyClass(pobj_ClassHash[i]);
	}

	if(ppobj_IteClass) HeapDefaultFree(ppobj_IteClass);
}

void CDBClass::ActionVtblSchedule(LONG_PTR ImageBase, LONG_PTR MemPos_CodeSection){
	int i;
	for(i=0;i<MAX_CLASS_HASH;i++){
		if(pobj_ClassHash[i]){
			CClass *pobj_c;
			pobj_c=pobj_ClassHash[i];
			while(1){
				pobj_c->ActionVtblSchedule(ImageBase,MemPos_CodeSection);

				if(pobj_c->pobj_NextClass==0) break;
				pobj_c=pobj_c->pobj_NextClass;
			}
		}
	}
}

CClass *CDBClass::Find( const string &fullName ) const
{
	char AreaName[VN_SIZE] = "";		//IuWFNgϐ
	char NestName[VN_SIZE] = "";		//qo
	bool isNest = SplitMemberName( fullName.c_str(), AreaName, NestName );

	int key;
	key=hash(NestName);

	if(pobj_ClassHash[key]){
		CClass *pobj_c;
		pobj_c=pobj_ClassHash[key];
		while(1){
			if( pobj_c->IsEqualSymbol( fullName ) ){
				//OԂƃNXv
				return pobj_c;
			}

			if(pobj_c->pobj_NextClass==0) break;
			pobj_c=pobj_c->pobj_NextClass;
		}
	}
	return NULL;
}
CClass *CDBClass::Find( const NamespaceScopes &namespaceScopes, const string &name ) const
{
	int key;
	key=hash(name.c_str());

	if(pobj_ClassHash[key]){
		CClass *pobj_c;
		pobj_c=pobj_ClassHash[key];
		while(1){
			if( pobj_c->IsEqualSymbol( namespaceScopes, name ) ){
				//OԂƃNXv
				return pobj_c;
			}

			if(pobj_c->pobj_NextClass==0) break;
			pobj_c=pobj_c->pobj_NextClass;
		}
	}
	return NULL;
}

CClass *CDBClass::AddClass( const NamespaceScopes &namespaceScopes, const char *name,int nowLine){
	//////////////////////////////////////////////////////////////////////////
	// NXǉ
	// Ô݂o^B̑̏SetClass\bhŁI
	//////////////////////////////////////////////////////////////////////////

	CClass *pobj_c;
	pobj_c=new CClass(namespaceScopes, name);

	if(lstrcmp(name,"String")==0){
		//StringNX
		pobj_StringClass=pobj_c;
	}
	if( lstrcmp( name, "Object" ) == 0 ){
		pObjectClass = pobj_c;
	}


	/////////////////////////////////
	// nbVf[^ɒǉ
	/////////////////////////////////

	int key;
	key=hash(name);

	if(pobj_ClassHash[key]){
		CClass *pobj_c2;
		pobj_c2=pobj_ClassHash[key];
		while(1){
			if( pobj_c2->IsEqualSymbol( namespaceScopes, name ) ){
				//OԋyуNXdꍇ
				SetError(15,name,nowLine);
				return 0;
			}

			if(pobj_c2->pobj_NextClass==0) break;
			pobj_c2=pobj_c2->pobj_NextClass;
		}
		pobj_c2->pobj_NextClass=pobj_c;
	}
	else{
		pobj_ClassHash[key]=pobj_c;
	}

	return pobj_c;	
}

void CDBClass::InitNames(void){
	extern char *basbuf;
	int i, i2;
	char temporary[VN_SIZE];

	// OԊǗ
	NamespaceScopes &namespaceScopes = Smoothie::Lexical::liveingNamespaceScopes;
	namespaceScopes.clear();

	for(i=0;;i++){
		if(basbuf[i]=='\0') break;

		if( basbuf[i] == 1 && basbuf[i+1] == ESC_NAMESPACE ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( basbuf[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=basbuf[i];
			}
			namespaceScopes.push_back( temporary );

			continue;
		}
		else if( basbuf[i] == 1 && basbuf[i+1] == ESC_ENDNAMESPACE ){
			if( namespaceScopes.size() <= 0 ){
				SetError(12, "End Namespace", i );
			}
			else{
				namespaceScopes.pop_back();
			}

			i += 2;
			continue;
		}

		if(basbuf[i]==1&&(
			basbuf[i+1]==ESC_CLASS||
			basbuf[i+1]==ESC_TYPE||
			basbuf[i+1]==ESC_INTERFACE
			)){
				int nowLine;
				nowLine=i;

				i+=2;
				//ACgCq
				if(memicmp(basbuf+i,"Align(",6)==0){
					i+=6;
					i=JumpStringInPare(basbuf,i)+1;
				}

				bool isEnum = false;
				if( basbuf[i] == 1 && basbuf[i+1] == ESC_ENUM ){
					// 񋓌^̏ꍇ
					isEnum = true;

					i+=2;
				}

				int i2;
				char temporary[VN_SIZE];
				for(i2=0;;i++,i2++){
					if(!IsVariableChar(basbuf[i])){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=basbuf[i];
				}

				//NXǉ
				CClass *pClass = pobj_DBClass->AddClass(namespaceScopes, temporary,nowLine);
				if( pClass ){
					if( basbuf[nowLine+1] == ESC_CLASS ){
						if( isEnum ){
							pClass->classType = CClass::Enum;
						}
						else{
							pClass->classType = CClass::Class;
						}
					}
					else if( basbuf[nowLine+1] == ESC_INTERFACE ){
						pClass->classType = CClass::Interface;
					}
					else{
						pClass->classType = CClass::Structure;
					}
				}
		}
	}
}


void CDBClass::AddMethod(CClass *pobj_c, DWORD dwAccess, BOOL bStatic, bool isConst, BOOL bAbstract,
						 BOOL bVirtual, BOOL bOverride, char *buffer, int nowLine){
	int i,i2;
	char temporary[VN_SIZE];

	i=2;
	for(i2=0;;i++,i2++){
		if(buffer[i]=='('||buffer[i]=='\0'){
			temporary[i2]=0;
			break;
		}
		temporary[i2]=buffer[i];
	}


	//֐nbV֓o^
	GlobalProc *pUserProc;
	pUserProc=AddSubData( NamespaceScopes(), buffer,nowLine,bVirtual,pobj_c, (bStatic!=0) );
	if(!pUserProc) return;


	////////////////////////////////////////////////////////////
	// RXgN^AfXgN^̏ꍇ̏
	////////////////////////////////////////////////////////////
	BOOL fConstructor=0,bDestructor=0;

	if(lstrcmp(temporary,pobj_c->name)==0){
		//RXgN^̏ꍇ

		//WRXgN^iȂj
		if(pUserProc->Params().size()==0) fConstructor=1;

		//IConstCq
		isConst = true;
	}
	else if(temporary[0]=='~'){
		//fXgN^̏ꍇ̖͂O`FbNs
		if(lstrcmp(temporary+1,pobj_c->name)!=0)
			SetError(117,NULL,nowLine);
		else
			bDestructor=1;
	}
	if(fConstructor||bDestructor){
		// RXgN^AfXgN^̃ANZVreB`FbN

		//IConstCq
		isConst = true;
	}

	if( fConstructor == 1 )
		pobj_c->ConstructorMemberSubIndex = (int)pobj_c->methods.size();
	else if( bDestructor )
		pobj_c->DestructorMemberSubIndex = (int)pobj_c->methods.size();



	//////////////////
	// d`FbN
	//////////////////

	if(pobj_c->DupliCheckMember(temporary)){
		SetError(15,temporary,nowLine);
		return;
	}

	//\bh
	foreach( CMethod *method, pobj_c->methods ){
		//NXƏdꍇ̓I[o[Chs
		if(method->pobj_InheritsClass) continue;

		if( method->pUserProc->GetName() == temporary ){
			if( Parameter::Equals( method->pUserProc->Params(), pUserProc->Params() ) ){
				//֐Ap[^vƂ
				SetError(15,pUserProc->GetName().c_str(),nowLine);
				return;
			}
		}
	}

	//z֐̏ꍇ
	if(bAbstract) pUserProc->CompleteCompile();

	//\bh̃I[o[Ch
	foreach( CMethod *method, pobj_c->methods ){
		if( method->pUserProc->GetName() == temporary ){
			if( Parameter::Equals( method->pUserProc->Params(), pUserProc->Params() ) ){

				if(method->bVirtual){
					//o֐㏑
					method->pUserProc=pUserProc;
					method->bAbstract=0;

					if(!bOverride){
						SetError(127,NULL,nowLine);
					}
					if(method->dwAccess!=dwAccess){
						SetError(128,NULL,nowLine);
					}

					pUserProc->SetMethod( method );
					return;
				}
			}
		}
	}

	if(bVirtual){
		pobj_c->vtbl_num++;
	}

	if(bOverride){
		SetError(12,"Override",nowLine);
	}

	if(bStatic){
		pobj_c->AddStaticMethod(pUserProc,dwAccess);
	}
	else{
		pobj_c->AddMethod(pUserProc, dwAccess, isConst, bAbstract, bVirtual);
	}
}

BOOL CDBClass::MemberVar_LoopRefCheck(const CClass &objClass){
	int i,i2,bRet=1;
	for(i=0;i<objClass.iMemberNum;i++){
		const CMember *pMember = objClass.ppobj_Member[i];
		if(pMember->IsStruct()){
			//zQƂłȂ`FbN
			if(pobj_LoopRefCheck->check(pMember->GetClass())){
				extern int cp;
				SetError(124,pMember->GetClass().name,cp);
				return 0;
			}

			pobj_LoopRefCheck->add(objClass.name);

			i2=MemberVar_LoopRefCheck(pMember->GetClass());
			if(bRet==1) bRet=i2;

			pobj_LoopRefCheck->del(objClass.name);
		}
	}

	return bRet;
}

void CDBClass::GetClass_recur(const char *lpszInheritsClass){
	extern char *basbuf;
	int i,i2,i3,sub_address,top_pos;
	DWORD dwAccess;
	char temporary[8192];

	// OԊǗ
	NamespaceScopes &namespaceScopes = Smoothie::Lexical::liveingNamespaceScopes;
	namespaceScopes.clear();

	for(i=0;;i++){
		if(basbuf[i]=='\0') break;


		// O
		if( basbuf[i] == 1 && basbuf[i+1] == ESC_NAMESPACE ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( basbuf[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=basbuf[i];
			}
			namespaceScopes.push_back( temporary );

			continue;
		}
		else if( basbuf[i] == 1 && basbuf[i+1] == ESC_ENDNAMESPACE ){
			if( namespaceScopes.size() <= 0 ){
				SetError(12, "End Namespace", i );
			}
			else{
				namespaceScopes.pop_back();
			}

			i += 2;
			continue;
		}



		if(basbuf[i]==1&&basbuf[i+1]==ESC_INTERFACE){
			//////////////////////////
			// C^[tFCX
			//////////////////////////

			top_pos=i;

			i+=2;

			//C^[tFCX擾
			GetIdentifierToken( temporary, basbuf, i );

			CClass *pobj_c=pobj_DBClass->Find(namespaceScopes, temporary);
			if(!pobj_c) continue;

			if(lpszInheritsClass){
				if(lstrcmp(lpszInheritsClass,pobj_c->name)!=0){
					//pǂݗp
					continue;
				}
			}

			if(pobj_c->ppobj_Member){
				//ɐǂ݂ĂƂ
				continue;
			}

			//op
			pobj_c->ppobj_Member=(CMember **)HeapAlloc(hHeap,0,1);
			pobj_c->iMemberNum=0;

			pobj_c->ConstructorMemberSubIndex=-1;
			pobj_c->DestructorMemberSubIndex=-1;

			if(basbuf[i+1]==1&&basbuf[i+2]==ESC_INHERITS){
				//psꍇ
				for(i+=3,i2=0;;i++,i2++){
					if(IsCommandDelimitation(basbuf[i])){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=basbuf[i];
				}

				if(lstrcmpi(temporary,pobj_c->name)==0){
					SetError(105,temporary,i);
					goto Interface_InheritsError;
				}

				//pNX擾
				CClass *pInheritsClass = Find(temporary);
				if( !pInheritsClass ){
					SetError(106,temporary,i);
					goto Interface_InheritsError;
				}

				//p
				if( !pobj_c->InheritsInterface( *pInheritsClass, i ) ){
					goto Interface_InheritsError;
				}
			}
			else{
				//p
				pobj_c->pobj_InheritsClass=0;

				//z֐̐
				pobj_c->vtbl_num=0;
			}
Interface_InheritsError:

			//oϐA֐擾
			while(1){
				i++;

				//G[
				if(basbuf[i]==1&&(basbuf[i+1]==ESC_CLASS||basbuf[i+1]==ESC_TYPE||basbuf[i+1]==ESC_INTERFACE)){
					SetError(22,"Interface",i);
					i--;
					break;
				}

				if(basbuf[i]==1&&basbuf[i+1]==ESC_INHERITS){
					SetError(111,NULL,i);
					break;
				}

				sub_address=i;

				for(i2=0;;i++,i2++){
					if(IsCommandDelimitation(basbuf[i])){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=basbuf[i];
				}
				if(temporary[0]=='\0'){
					if(basbuf[i]=='\0'){
						i--;
						SetError(22,"Interface",top_pos);
						break;
					}
					continue;
				}

				//End InterfaceLq̏ꍇ
				if(temporary[0]==1&&temporary[1]==ESC_ENDINTERFACE) break;

				if(!(temporary[0]==1&&(
					temporary[1]==ESC_SUB||temporary[1]==ESC_FUNCTION
					))){
					SetError(1,NULL,i);
					break;
				}

				//o֐ǉ
				AddMethod(pobj_c,
					ACCESS_PUBLIC,		//PublicANZX
					0,					//StaticwȂ
					false,				//Constł͂Ȃ
					1,					//Abstract
					1,					//Virtual
					0,
					temporary,
					sub_address
					);
			}
		}

		if(basbuf[i]==1&&(basbuf[i+1]==ESC_CLASS||basbuf[i+1]==ESC_TYPE)){
			//////////////////////////
			// NX
			//////////////////////////

			top_pos=i;

			const DWORD dwClassType=basbuf[i+1];

			i+=2;

			//ACgCq
			int iAlign=0;
			if(memicmp(basbuf+i,"Align(",6)==0){
				i+=6;
				i+=GetStringInPare_RemovePare(temporary,basbuf+i)+1;
				iAlign=atoi(temporary);

				if(!(iAlign==1||iAlign==2||iAlign==4||iAlign==8||iAlign==16))
					SetError(51,NULL,i);
			}

			if( basbuf[i] == 1 && basbuf[i+1] == ESC_ENUM ){
				// 񋓌^̏ꍇ
				i+=2;
			}

			//NX擾
			GetIdentifierToken( temporary, basbuf, i );

			CClass *pobj_c=pobj_DBClass->Find(namespaceScopes, temporary);
			if(!pobj_c) continue;

			if(lpszInheritsClass){
				if(lstrcmp(lpszInheritsClass,pobj_c->name)!=0){
					//pǂݗp
					continue;
				}
			}

			if(pobj_c->ppobj_Member){
				//ɐǂ݂ĂƂ
				continue;
			}

			pobj_c->iAlign=iAlign;

			//op
			pobj_c->ppobj_Member=(CMember **)HeapAlloc(hHeap,0,1);
			pobj_c->iMemberNum=0;

			pobj_c->ConstructorMemberSubIndex=-1;
			pobj_c->DestructorMemberSubIndex=-1;

			//ANZX̏lZbg
			if(dwClassType==ESC_CLASS) dwAccess=ACCESS_PRIVATE;
			else dwAccess=ACCESS_PUBLIC;

			if( lstrcmp( pobj_c->name, "Object" ) == 0 || dwClassType == ESC_TYPE ){
				//p
				pobj_c->pobj_InheritsClass=0;

				//z֐̐
				pobj_c->vtbl_num=0;
			}
			else{
				if(basbuf[i+1]==1&&basbuf[i+2]==ESC_INHERITS){
					//psꍇ
					for(i+=3,i2=0;;i++,i2++){
						if(IsCommandDelimitation(basbuf[i])){
							temporary[i2]=0;
							break;
						}
						temporary[i2]=basbuf[i];
					}

					if(lstrcmpi(temporary,pobj_c->name)==0){
						SetError(105,temporary,i);
						goto InheritsError;
					}
				}
				else{
					//Objectp
					lstrcpy( temporary, "Object" );
				}

				//pNX擾
				CClass *pInheritsClass = Find(temporary);
				if( !pInheritsClass ){
					SetError(106,temporary,i);
					goto InheritsError;
				}

				if( pInheritsClass->IsInterface() ){
					// NXpĂȂƂ
					CClass *pObjectClass = Find("Object");
					if( !pObjectClass ){
						SetError(106,"Object",i);
						goto InheritsError;
					}

					if( !pobj_c->Inherits( *pObjectClass, i ) ){
						goto InheritsError;
					}
				}

				//p
				if( !pobj_c->Inherits( *pInheritsClass, i ) ){
					goto InheritsError;
				}
			}
InheritsError:

			//oƃ\bh擾
			while(1){
				i++;

				//G[
				if(basbuf[i]==1&&(basbuf[i+1]==ESC_CLASS||basbuf[i+1]==ESC_TYPE)){
					SetError(22,"Class",i);
					i--;
					break;
				}

				if(basbuf[i]==1&&basbuf[i+1]==ESC_INHERITS){
					SetError(111,NULL,i);
					break;
				}

				//StaticCq
				BOOL bStatic;
				if(basbuf[i]==1&&basbuf[i+1]==ESC_STATIC){
					bStatic=1;
					i+=2;
				}
				else bStatic=0;

				//ConstCq
				bool isConst = false;
				if( basbuf[i] == 1 && basbuf[i + 1] == ESC_CONST ){
					isConst = true;
					i += 2;
				}
/*
				//RefCq
				bool isRef = false;
				if( basbuf[i] == 1 && basbuf[i + 1] == ESC_BYREF ){
					isRef = true;
					i += 2;
				}*/

				if(basbuf[i]==1&&(
					basbuf[i+1]==ESC_ABSTRACT||basbuf[i+1]==ESC_VIRTUAL||basbuf[i+1]==ESC_OVERRIDE||
					basbuf[i+1]==ESC_SUB||basbuf[i+1]==ESC_FUNCTION
					)){
					i3=basbuf[i+1];
					sub_address=i;
				}
				else i3=0;

				BOOL bVirtual=0,bAbstract=0,bOverride=0;
				if(i3==ESC_ABSTRACT){
					bAbstract=1;
					bVirtual=1;
					i+=2;

					i3=basbuf[i+1];
				}
				else if(i3==ESC_VIRTUAL){
					bAbstract=0;
					bVirtual=1;
					i+=2;

					i3=basbuf[i+1];
				}
				else if(i3==ESC_OVERRIDE){
					bOverride=1;
					bVirtual=1;

					i+=2;

					i3=basbuf[i+1];
				}

				for(i2=0;;i++,i2++){
					if(IsCommandDelimitation(basbuf[i])){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=basbuf[i];
				}
				if(temporary[0]=='\0'){
					if(basbuf[i]=='\0'){

						if(dwClassType==ESC_CLASS)
							SetError(22,"Class",top_pos);
						else
							SetError(22,"Type",top_pos);

						i--;
						break;
					}
					continue;
				}

				//End ClassLq̏ꍇ
				if(temporary[0]==1&&temporary[1]==ESC_ENDCLASS&&dwClassType==ESC_CLASS) break;
				if(temporary[0]==1&&temporary[1]==ESC_ENDTYPE&&dwClassType==ESC_TYPE) break;

				//ANZXύX
				if(lstrcmpi(temporary,"Private")==0){
					dwAccess=ACCESS_PRIVATE;
					continue;
				}
				if(lstrcmpi(temporary,"Public")==0){
					dwAccess=ACCESS_PUBLIC;
					continue;
				}
				if(lstrcmpi(temporary,"Protected")==0){
					dwAccess=ACCESS_PROTECTED;
					continue;
				}

				extern int cp;
				if(i3==0){
					if(bStatic){
						//ÓIoǉ
						cp=i;	//G[p
						pobj_c->AddStaticMember( dwAccess, isConst, false, temporary, i);
					}
					else{
						//oǉ
						cp=i;	//G[p
						pobj_c->AddMember( dwAccess, isConst, false, temporary );


						if(pobj_c->ppobj_Member[pobj_c->iMemberNum-1]->IsStruct()){
							if(pobj_c->ppobj_Member[pobj_c->iMemberNum-1]->GetClass().ppobj_Member==0){
								//QƐ悪ǂݎĂȂƂ
								GetClass_recur(pobj_c->ppobj_Member[pobj_c->iMemberNum-1]->GetClass().name);
							}
						}


						if(pobj_c->ppobj_Member[pobj_c->iMemberNum-1]->IsStruct()){
							//zQƂ̃`FbN
							pobj_LoopRefCheck->add(pobj_c->name);
							if(!MemberVar_LoopRefCheck(pobj_c->ppobj_Member[pobj_c->iMemberNum-1]->GetClass())){
								//G[
								pobj_c->ppobj_Member[pobj_c->iMemberNum-1]->SetBasicType( DEF_PTR_VOID );
							}
							pobj_LoopRefCheck->del(pobj_c->name);
						}
					}
				}
				else{
					//\bhǉ
					cp=i;	//G[p
					AddMethod(pobj_c,
						dwAccess,
						bStatic,
						isConst,
						bAbstract,
						bVirtual,
						bOverride,
						temporary,
						sub_address);

					if(bAbstract) continue;

					for(;;i++){
						if(basbuf[i]=='\0'){
							i--;
							break;
						}
						if(basbuf[i-1]!='*'&&
							basbuf[i]==1&&(
							basbuf[i+1]==ESC_SUB||
							basbuf[i+1]==ESC_FUNCTION||
							basbuf[i+1]==ESC_MACRO||
							basbuf[i+1]==ESC_TYPE||
							basbuf[i+1]==ESC_CLASS||
							basbuf[i+1]==ESC_INTERFACE||
							basbuf[i+1]==ESC_ENUM)){
							GetDefaultNameFromES(i3,temporary);
							SetError(22,temporary,i);
						}
						if(basbuf[i]==1&&basbuf[i+1]==GetEndXXXCommand((char)i3)){
							i+=2;
							break;
						}
					}
				}
			}
		}
	}
}

void CDBClass::GetAllClassInfo(void){
	//[vp`FbNp̃NX
	pobj_LoopRefCheck=new CLoopRefCheck();

	//NX擾
	GetClass_recur(0);

	delete pobj_LoopRefCheck;
	pobj_LoopRefCheck=0;

	// Ce[^p̃f[^
	pobj_DBClass->Iterator_Init();
}

void CDBClass::Compile_System_InitializeUserTypes(){
	char temporary[VN_SIZE];

	////////////////////////////////////////////////////////////////////
	// NXo^
	////////////////////////////////////////////////////////////////////

	// Ce[^Zbg
	Iterator_Reset();

	while( Iterator_HasNext() ){
		const CClass &objClass = *Iterator_GetNext();

		if( !objClass.IsUsing() ){
			// gp̃NX͖
			continue;
		}

		char referenceOffsetsBuffer[1024] = "";
		int numOfReference = 0;
		for( int i=0; i<objClass.iMemberNum; i++ ){
			CMember &member = *objClass.ppobj_Member[i];

			if( member.IsObject() || member.IsPointer() ){
				if( referenceOffsetsBuffer[0] ){
					lstrcat( referenceOffsetsBuffer, "," );
				}

				sprintf( referenceOffsetsBuffer + lstrlen( referenceOffsetsBuffer ),
					"%d",
					objClass.GetMemberOffset( member.name ) );

				numOfReference++;
			}
		}

		sprintf( temporary
			, "Add(%c%c_System_TypeForClass(\"%s\",\"%s\",[%s],%d))"
			, 1
			, ESC_NEW
			, ""						// O (TODO: )
			, objClass.name				// NX
			, referenceOffsetsBuffer	// QƃoItZbgz
			, numOfReference			// Qƃǒ
			);

		// RpC
		ChangeOpcode( temporary );

		// lCeBuR[hobt@̍Ċm
		ReallocNativeCodeBuffer();
	}


	////////////////////////////////////////////////////////////////////
	// NXo^
	////////////////////////////////////////////////////////////////////

	sprintf(temporary, "%c%ctempType=Nothing%c%cTypeBaseImpl"
		, HIBYTE( COM_DIM )
		, LOBYTE( COM_DIM )
		, 1
		, ESC_AS
		);
	ChangeOpcode( temporary );

	// Ce[^Zbg
	Iterator_Reset();

	while( Iterator_HasNext() ){
		const CClass &objClass = *Iterator_GetNext();

		if( !objClass.IsUsing() ){
			// gp̃NX͖
			continue;
		}

		if( objClass.pobj_InheritsClass ){
			sprintf( temporary
				, "tempType=Search(\"%s\",\"%s\")"
				, ""				// O (TODO: )
				, objClass.name		// NX
				);

			// RpC
			ChangeOpcode( temporary );

			sprintf( temporary
				, "tempType.SetBaseType(Search(\"%s\",\"%s\"))"
				, ""								// O (TODO: )
				, objClass.pobj_InheritsClass->name	// NX
				);

			// RpC
			ChangeOpcode( temporary );
		}

		// lCeBuR[hobt@̍Ċm
		ReallocNativeCodeBuffer();
	}



	////////////////////////////////////////////////////////////////////
	// p֌Wo^
	////////////////////////////////////////////////////////////////////
	// TODO: 
	/*

	// Ce[^Zbg
	Iterator_Reset();

	while( Iterator_HasNext() ){
		CClass *pClass = Iterator_GetNext();

		sprintf( genBuffer + length
			, "obj.Search( \"%s\" ).SetBaseType( Search( \"%s\" ) ):"
			, ""				// NX
			, pClass->name		// NX
			);
		length += lstrlen( genBuffer + length );

		while( length + 8192 > max ){
			max += 8192;
			genBuffer = (char *)realloc( genBuffer, max );
		}
	}*/
}



CClass *CDBClass::GetStringClass() const
{
	if( !pStringClass ){
		SetError();
		return NULL;
	}
	return pStringClass;
}
CClass *CDBClass::GetObjectClass() const
{
	if( !pObjectClass ){
		SetError();
		return NULL;
	}
	return pObjectClass;
}

void CDBClass::StartCompile( UserProc *pUserProc ){
	pCompilingClass = pUserProc->GetParentClassPtr();
	if( pCompilingClass ){
		pCompilingClass->Using();

		pCompilingMethod = pCompilingClass->GetMethodInfo( pUserProc );
		if( !pCompilingMethod ){
			pCompilingMethod = pCompilingClass->GetStaticMethodInfo( pUserProc );
			if( !pCompilingMethod ){
				SetError(300,NULL,cp);
			}
		}
	}
	else{
		pCompilingMethod = NULL;
	}
}
CClass *CDBClass::GetNowCompilingClass(){
	return pCompilingClass;
}
CMethod *CDBClass::GetNowCompilingMethodInfo(){
	return pCompilingMethod;
}




//////////////////////
// Ce[^
//////////////////////

void CDBClass::Iterator_Init(void){
	if(ppobj_IteClass) HeapDefaultFree(ppobj_IteClass);

	iIteMaxNum=0;
	iIteNextNum=0;
	ppobj_IteClass=(CClass **)HeapAlloc(hHeap,0,1);

	int i;
	for(i=0;i<MAX_CLASS_HASH;i++){
		if(pobj_ClassHash[i]){
			CClass *pobj_c;
			pobj_c=pobj_ClassHash[i];
			while(1){
				ppobj_IteClass=(CClass **)HeapReAlloc(hHeap,0,ppobj_IteClass,(iIteMaxNum+1)*sizeof(CClass *));
				ppobj_IteClass[iIteMaxNum]=pobj_c;
				iIteMaxNum++;

				if(pobj_c->pobj_NextClass==0) break;
				pobj_c=pobj_c->pobj_NextClass;
			}
		}
	}
}
void CDBClass::Iterator_Reset(void){
	iIteNextNum = 0;
}
BOOL CDBClass::Iterator_HasNext(void){
	if(iIteNextNum<iIteMaxNum) return 1;
	return 0;
}
CClass *CDBClass::Iterator_GetNext(void){
	CClass *pobj_c;
	pobj_c=ppobj_IteClass[iIteNextNum];
	iIteNextNum++;
	return pobj_c;
}
int CDBClass::Iterator_GetMaxCount(void){
	return iIteMaxNum;
}
