#pragma once

#include "Type.h"

class Variable : public Type
{
	const NamespaceScopes namespaceScopes;
	string name;
	bool isConst;
	bool isRef;
	bool isArray;
	int subScripts[MAX_ARRAYDIM];

	bool isParameter;

public:
	Variable( const string &name, const Type &type, bool isConst = false, bool isRef = false )
		: Type( type )
		, name( name )
		, isConst( isConst )
		, isRef( isRef )
		, isArray( false )
		, isParameter( false)
	{
		subScripts[0] = -1;
	}
	Variable( const NamespaceScopes &namespaceScopes, const string &name, const Type &type, bool isConst = false, bool isRef = false )
		: namespaceScopes( namespaceScopes )
		, Type( type )
		, name( name )
		, isConst( isConst )
		, isRef( isRef )
		, isArray( false )
		, isParameter( false)
	{
		subScripts[0] = -1;
	}
	Variable( const Variable &var )
		: Type( var )
		, name( var.name )
		, isConst( var.isConst )
		, isRef( var.isRef )
		, isArray( false )
		, isParameter( false )
	{
		subScripts[0] = -1;
		if( var.isArray ){
			SetArray( var.subScripts );
		}
	}
	~Variable(){}

	void SetArray( const int *pSubScripts ){
		isArray = true;
		memcpy( this->subScripts, pSubScripts, sizeof(int) * MAX_ARRAYDIM );
	}

	const string &GetName() const
	{
		return name;
	}

	bool IsEqualSymbol( const NamespaceScopes &namespaceScopes, const string &name ) const;
	bool IsEqualSymbol( const string &name ) const;

	void ConstOff(){
		isConst = false;
	}
	void ConstOn(){
		isConst = true;
	}
	bool IsConst() const
	{
		return isConst;
	}
	bool IsRef() const
	{
		return isRef;
	}
	bool IsArray()const
	{
		return isArray;
	}
	const int *GetSubScriptsPtr() const
	{
		return subScripts;
	}

	void ThisIsParameter(){
		isParameter = true;
	}
	bool IsParameter() const
	{
		return isParameter;
	}


	int GetMemorySize() const
	{
		if( isRef || isParameter ){
			return PTR_SIZE;
		}

		int size = Type::GetSize();

		if( isArray ){
			int num = 1;
			for( int i=0; i<MAX_ARRAYDIM; i++){
				if(subScripts[i]==-1) break;
				num *= subScripts[i]+1;
			}
			size *= num;
		}

		if( size % PTR_SIZE ){
			size += PTR_SIZE-(size%PTR_SIZE);
		}

		return size;
	}


	/* --- ItZbg ---

		O[oϐŏobt@Ȃꍇ͍ŏʃrbg1ZbgA
		obt@̗LʂB
		ǐAXPW[sɂAۂ̔zuɕёւj*/
	int offset;

	//RXgN^pp[^
	string paramStrForConstructor;

	//LVJXR[vp
	int ScopeStartAddress;
	int ScopeEndAddress;
	int ScopeLevel;
	BOOL bLiving;


	int source_code_address;
};

class Variables : public vector<Variable *>
{
public:
	Variables(){}
	~Variables(){
		clear();
	}

	void clear(){
		for( int i=0; i<(int)this->size(); i++ ){
			delete (*this)[i];
		}

		vector<Variable *>::clear();
	}

	bool DuplicateCheck( const string &varName ) const
	{
		//LVJXR[vlďd
		for( int i=(int)this->size()-1; i>=0 ; i-- ){
			Variable &var = *(*this)[i];
			if( var.bLiving											//݂̃XR[vŗLȂ
				&& var.ScopeLevel == obj_LexScopes.GetNowLevel()	//݂̃XR[vƓꃌx
				){
					if( var.IsEqualSymbol( varName ) ){
						return true;
					}
			}
		}
		return false;
	}

	const Variable *BackSearch( const string &varName ) const
	{
		//LVJXR[vlăobNT[`
		for( int i=(int)this->size()-1; i>=0 ; i-- ){
			Variable &var = *(*this)[i];
			if( var.bLiving											//݂̃XR[vŗLȂ
				&& var.ScopeLevel <= obj_LexScopes.GetNowLevel()	//݂̃XR[vx𒴂Ȃ́iReturnɂlj
				){
					if( var.IsEqualSymbol( varName ) ){
						return &var;
					}
			}
		}
		return NULL;
	}

	const Variable *Find( const string &varName )const
	{
		int max = (int)this->size();
		for( int i=0; i<max; i++ ){
			Variable *pVar = (*this)[i];
			if( pVar->IsEqualSymbol( varName ) ){
				return pVar;
			}
		}
		return NULL;
	}
};

extern Variables globalVars;


